/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.graphics.ThemedTextGraphics;
import com.googlecode.lanterna.gui2.TextGUI;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowPostRenderer;

public class WindowShadowRenderer
implements WindowPostRenderer {
    @Override
    public void postRender(ThemedTextGraphics textGraphics, TextGUI textGUI, Window window) {
        TextCharacter tc;
        char characterToDraw;
        int row;
        TerminalPosition windowPosition = window.getPosition();
        TerminalSize decoratedWindowSize = window.getDecoratedSize();
        ThemeDefinition themeDefinition = window.getTheme().getDefinition(WindowShadowRenderer.class);
        textGraphics.applyThemeStyle(themeDefinition.getNormal());
        char filler = themeDefinition.getCharacter("FILLER", ' ');
        boolean useDoubleWidth = themeDefinition.getBooleanProperty("DOUBLE_WIDTH", true);
        boolean useTransparency = themeDefinition.getBooleanProperty("TRANSPARENT", false);
        TerminalPosition lowerLeft = windowPosition.withRelativeColumn(useDoubleWidth ? 2 : 1).withRelativeRow(decoratedWindowSize.getRows());
        TerminalPosition lowerRight = lowerLeft.withRelativeColumn(decoratedWindowSize.getColumns() - (useDoubleWidth ? 3 : 2));
        for (int column = lowerLeft.getColumn(); column <= lowerRight.getColumn() + 1; ++column) {
            TextCharacter tc2;
            char characterToDraw2 = filler;
            if (useTransparency && (tc2 = textGraphics.getCharacter(column, lowerLeft.getRow())) != null) {
                characterToDraw2 = tc2.getCharacterString().charAt(0);
            }
            textGraphics.setCharacter(column, lowerLeft.getRow(), characterToDraw2);
            if (!TerminalTextUtils.isCharDoubleWidth(characterToDraw2)) continue;
            ++column;
        }
        lowerRight = lowerRight.withRelativeColumn(1);
        TerminalPosition upperRight = lowerRight.withRelativeRow(-decoratedWindowSize.getRows() + 1);
        boolean hasDoubleWidthShadow = false;
        for (row = upperRight.getRow(); row < lowerRight.getRow(); ++row) {
            characterToDraw = filler;
            if (useTransparency && (tc = textGraphics.getCharacter(upperRight.getColumn(), row)) != null) {
                characterToDraw = tc.getCharacterString().charAt(0);
            }
            textGraphics.setCharacter(upperRight.getColumn(), row, characterToDraw);
            if (!TerminalTextUtils.isCharDoubleWidth(characterToDraw)) continue;
            hasDoubleWidthShadow = true;
        }
        textGraphics.applyThemeStyle(themeDefinition.getNormal());
        if (useDoubleWidth || hasDoubleWidthShadow) {
            upperRight = upperRight.withRelativeColumn(1);
            for (row = upperRight.getRow(); row <= lowerRight.getRow(); ++row) {
                TextCharacter neighbour;
                characterToDraw = filler;
                if (useTransparency && (tc = textGraphics.getCharacter(upperRight.getColumn(), row)) != null && !tc.isDoubleWidth()) {
                    characterToDraw = tc.getCharacterString().charAt(0);
                }
                if ((neighbour = textGraphics.getCharacter(upperRight.getColumn() - 1, row)) == null || neighbour.isDoubleWidth()) continue;
                textGraphics.setCharacter(upperRight.getColumn(), row, characterToDraw);
            }
        }
    }
}

