/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.AbstractInteractableComponent;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.InteractableRenderer;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CheckBox
extends AbstractInteractableComponent<CheckBox> {
    private final List<Listener> listeners;
    private String label;
    private boolean checked;

    public CheckBox() {
        this("");
    }

    public CheckBox(String label) {
        if (label == null) {
            throw new IllegalArgumentException("Cannot create a CheckBox with null label");
        }
        if (label.contains("\n") || label.contains("\r")) {
            throw new IllegalArgumentException("Multiline checkbox labels are not supported");
        }
        this.listeners = new CopyOnWriteArrayList<Listener>();
        this.label = label;
        this.checked = false;
    }

    public synchronized CheckBox setChecked(boolean checked) {
        this.checked = checked;
        this.runOnGUIThreadIfExistsOtherwiseRunDirect(() -> {
            for (Listener listener : this.listeners) {
                listener.onStatusChanged(checked);
            }
        });
        this.invalidate();
        return this;
    }

    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public Interactable.Result handleKeyStroke(KeyStroke keyStroke) {
        if (this.isKeyboardActivationStroke(keyStroke)) {
            this.setChecked(!this.isChecked());
            return Interactable.Result.HANDLED;
        }
        if (this.isMouseActivationStroke(keyStroke)) {
            this.getBasePane().setFocusedInteractable(this);
            this.setChecked(!this.isChecked());
            return Interactable.Result.HANDLED;
        }
        return super.handleKeyStroke(keyStroke);
    }

    public synchronized CheckBox setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("Cannot set CheckBox label to null");
        }
        this.label = label;
        this.invalidate();
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public CheckBox addListener(Listener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    public CheckBox removeListener(Listener listener) {
        this.listeners.remove(listener);
        return this;
    }

    @Override
    protected CheckBoxRenderer createDefaultRenderer() {
        return new DefaultCheckBoxRenderer();
    }

    public static class DefaultCheckBoxRenderer
    extends CheckBoxRenderer {
        private static final TerminalPosition CURSOR_LOCATION = new TerminalPosition(1, 0);

        @Override
        public TerminalPosition getCursorLocation(CheckBox component) {
            if (component.getThemeDefinition().isCursorVisible()) {
                return CURSOR_LOCATION;
            }
            return null;
        }

        @Override
        public TerminalSize getPreferredSize(CheckBox component) {
            int width = 3;
            if (!component.label.isEmpty()) {
                width += 1 + TerminalTextUtils.getColumnWidth(component.label);
            }
            return new TerminalSize(width, 1);
        }

        @Override
        public void drawComponent(TextGUIGraphics graphics, CheckBox component) {
            ThemeDefinition themeDefinition = component.getThemeDefinition();
            if (component.isFocused()) {
                graphics.applyThemeStyle(themeDefinition.getActive());
            } else {
                graphics.applyThemeStyle(themeDefinition.getNormal());
            }
            graphics.fill(' ');
            graphics.putString(4, 0, component.label);
            if (component.isFocused()) {
                graphics.applyThemeStyle(themeDefinition.getPreLight());
            } else {
                graphics.applyThemeStyle(themeDefinition.getInsensitive());
            }
            graphics.setCharacter(0, 0, themeDefinition.getCharacter("LEFT_BRACKET", '['));
            graphics.setCharacter(2, 0, themeDefinition.getCharacter("RIGHT_BRACKET", ']'));
            graphics.setCharacter(3, 0, ' ');
            if (component.isFocused()) {
                graphics.applyThemeStyle(themeDefinition.getSelected());
            } else {
                graphics.applyThemeStyle(themeDefinition.getNormal());
            }
            graphics.setCharacter(1, 0, component.isChecked() ? themeDefinition.getCharacter("MARKER", 'x') : (char)' ');
        }
    }

    public static abstract class CheckBoxRenderer
    implements InteractableRenderer<CheckBox> {
    }

    public static interface Listener {
        public void onStatusChanged(boolean var1);
    }
}

