/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.gui2.AbstractComposite;
import com.googlecode.lanterna.gui2.BasePane;
import com.googlecode.lanterna.gui2.BasePaneListener;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.ComponentRenderer;
import com.googlecode.lanterna.gui2.Container;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.InteractableLookupMap;
import com.googlecode.lanterna.gui2.TextGUI;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.menu.MenuBar;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.input.MouseAction;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractBasePane<T extends BasePane>
implements BasePane {
    protected final ContentHolder contentHolder = new ContentHolder();
    private final CopyOnWriteArrayList<BasePaneListener<T>> listeners = new CopyOnWriteArrayList();
    protected InteractableLookupMap interactableLookupMap = new InteractableLookupMap(new TerminalSize(80, 25));
    private Interactable focusedInteractable;
    private boolean invalid = false;
    private boolean strictFocusChange = false;
    private boolean enableDirectionBasedMovements = true;
    private Theme theme = null;
    private Interactable mouseDownForDrag = null;

    protected AbstractBasePane() {
    }

    @Override
    public boolean isInvalid() {
        return this.invalid || this.contentHolder.isInvalid();
    }

    @Override
    public void invalidate() {
        this.invalid = true;
        this.contentHolder.invalidate();
    }

    @Override
    public void draw(TextGUIGraphics graphics) {
        graphics.applyThemeStyle(this.getTheme().getDefinition(Window.class).getNormal());
        graphics.fill(' ');
        if (!this.interactableLookupMap.getSize().equals(graphics.getSize())) {
            this.interactableLookupMap = new InteractableLookupMap(graphics.getSize());
        } else {
            this.interactableLookupMap.reset();
        }
        this.contentHolder.draw(graphics);
        this.contentHolder.updateLookupMap(this.interactableLookupMap);
        this.invalid = false;
    }

    @Override
    public boolean handleInput(KeyStroke key) {
        AtomicBoolean deliverEvent = new AtomicBoolean(true);
        for (BasePaneListener<T> listener : this.listeners) {
            listener.onInput(this.self(), key, deliverEvent);
        }
        if (!deliverEvent.get()) {
            return true;
        }
        boolean handled = this.doHandleInput(key);
        if (!handled) {
            AtomicBoolean hasBeenHandled = new AtomicBoolean(false);
            for (BasePaneListener<T> listener : this.listeners) {
                listener.onUnhandledInput(this.self(), key, hasBeenHandled);
            }
            handled = hasBeenHandled.get();
        }
        return handled;
    }

    abstract T self();

    private boolean doHandleInput(KeyStroke key) {
        boolean result = false;
        if (key.getKeyType() == KeyType.MouseEvent) {
            return this.handleMouseInput((MouseAction)key);
        }
        Interactable.FocusChangeDirection direction = Interactable.FocusChangeDirection.TELEPORT;
        Interactable nextFocus = null;
        if (this.focusedInteractable == null) {
            MenuBar menuBar = this.getMenuBar();
            Component baseComponent = this.getComponent();
            switch (key.getKeyType()) {
                case Tab: 
                case ArrowRight: 
                case ArrowDown: {
                    direction = Interactable.FocusChangeDirection.NEXT;
                    nextFocus = menuBar.nextFocus(null);
                    if (nextFocus != null) break;
                    if (baseComponent instanceof Container) {
                        nextFocus = ((Container)baseComponent).nextFocus(null);
                        break;
                    }
                    if (!(baseComponent instanceof Interactable)) break;
                    nextFocus = (Interactable)baseComponent;
                    break;
                }
                case ReverseTab: 
                case ArrowUp: 
                case ArrowLeft: {
                    direction = Interactable.FocusChangeDirection.PREVIOUS;
                    if (baseComponent instanceof Container) {
                        nextFocus = ((Container)baseComponent).previousFocus(null);
                    } else if (baseComponent instanceof Interactable) {
                        nextFocus = (Interactable)baseComponent;
                    }
                    if (nextFocus != null) break;
                    nextFocus = menuBar.previousFocus(null);
                }
            }
            if (nextFocus != null) {
                this.setFocusedInteractable(nextFocus, direction);
                result = true;
            }
        } else {
            Interactable.Result handleResult = this.focusedInteractable.handleInput(key);
            if (!this.enableDirectionBasedMovements) {
                if (handleResult == Interactable.Result.MOVE_FOCUS_DOWN || handleResult == Interactable.Result.MOVE_FOCUS_RIGHT) {
                    handleResult = Interactable.Result.MOVE_FOCUS_NEXT;
                } else if (handleResult == Interactable.Result.MOVE_FOCUS_UP || handleResult == Interactable.Result.MOVE_FOCUS_LEFT) {
                    handleResult = Interactable.Result.MOVE_FOCUS_PREVIOUS;
                }
            }
            switch (handleResult) {
                case HANDLED: {
                    result = true;
                    break;
                }
                case UNHANDLED: {
                    for (Container parent = this.focusedInteractable.getParent(); parent != null; parent = parent.getParent()) {
                        if (!parent.handleInput(key)) continue;
                        return true;
                    }
                    result = false;
                    break;
                }
                case MOVE_FOCUS_NEXT: {
                    nextFocus = this.contentHolder.nextFocus(this.focusedInteractable);
                    if (nextFocus == null) {
                        nextFocus = this.contentHolder.nextFocus(null);
                    }
                    direction = Interactable.FocusChangeDirection.NEXT;
                    break;
                }
                case MOVE_FOCUS_PREVIOUS: {
                    nextFocus = this.contentHolder.previousFocus(this.focusedInteractable);
                    if (nextFocus == null) {
                        nextFocus = this.contentHolder.previousFocus(null);
                    }
                    direction = Interactable.FocusChangeDirection.PREVIOUS;
                    break;
                }
                case MOVE_FOCUS_DOWN: {
                    nextFocus = this.interactableLookupMap.findNextDown(this.focusedInteractable);
                    direction = Interactable.FocusChangeDirection.DOWN;
                    if (nextFocus != null || this.strictFocusChange) break;
                    nextFocus = this.contentHolder.nextFocus(this.focusedInteractable);
                    direction = Interactable.FocusChangeDirection.NEXT;
                    break;
                }
                case MOVE_FOCUS_LEFT: {
                    nextFocus = this.interactableLookupMap.findNextLeft(this.focusedInteractable);
                    direction = Interactable.FocusChangeDirection.LEFT;
                    break;
                }
                case MOVE_FOCUS_RIGHT: {
                    nextFocus = this.interactableLookupMap.findNextRight(this.focusedInteractable);
                    direction = Interactable.FocusChangeDirection.RIGHT;
                    break;
                }
                case MOVE_FOCUS_UP: {
                    nextFocus = this.interactableLookupMap.findNextUp(this.focusedInteractable);
                    direction = Interactable.FocusChangeDirection.UP;
                    if (nextFocus != null || this.strictFocusChange) break;
                    nextFocus = this.contentHolder.previousFocus(this.focusedInteractable);
                    direction = Interactable.FocusChangeDirection.PREVIOUS;
                }
            }
        }
        if (nextFocus != null) {
            this.setFocusedInteractable(nextFocus, direction);
            result = true;
        }
        return result;
    }

    private boolean handleMouseInput(MouseAction mouseAction) {
        TerminalPosition localCoordinates = this.fromGlobal(mouseAction.getPosition());
        if (localCoordinates == null) {
            return false;
        }
        Interactable interactable = this.interactableLookupMap.getInteractableAt(localCoordinates);
        if (mouseAction.isMouseDown()) {
            this.mouseDownForDrag = interactable;
        }
        Interactable wasMouseDownForDrag = this.mouseDownForDrag;
        if (mouseAction.isMouseUp()) {
            this.mouseDownForDrag = null;
        }
        if (mouseAction.isMouseDrag() && this.mouseDownForDrag != null) {
            return this.mouseDownForDrag.handleInput(mouseAction) == Interactable.Result.HANDLED;
        }
        if (interactable == null) {
            return false;
        }
        if (mouseAction.isMouseUp()) {
            if (wasMouseDownForDrag == interactable) {
                return interactable.handleInput(mouseAction) == Interactable.Result.HANDLED;
            }
            return false;
        }
        return interactable.handleInput(mouseAction) == Interactable.Result.HANDLED;
    }

    @Override
    public Component getComponent() {
        return this.contentHolder.getComponent();
    }

    @Override
    public void setComponent(Component component) {
        this.contentHolder.setComponent(component);
    }

    @Override
    public Interactable getFocusedInteractable() {
        return this.focusedInteractable;
    }

    @Override
    public TerminalPosition getCursorPosition() {
        if (this.focusedInteractable == null) {
            return null;
        }
        TerminalPosition position = this.focusedInteractable.getCursorLocation();
        if (position == null) {
            return null;
        }
        if (position.getColumn() < 0 || position.getRow() < 0 || position.getColumn() >= this.focusedInteractable.getSize().getColumns() || position.getRow() >= this.focusedInteractable.getSize().getRows()) {
            return null;
        }
        return this.focusedInteractable.toBasePane(position);
    }

    @Override
    public void setFocusedInteractable(Interactable toFocus) {
        this.setFocusedInteractable(toFocus, toFocus != null ? Interactable.FocusChangeDirection.TELEPORT : Interactable.FocusChangeDirection.RESET);
    }

    protected void setFocusedInteractable(Interactable toFocus, Interactable.FocusChangeDirection direction) {
        if (this.focusedInteractable == toFocus) {
            return;
        }
        if (toFocus != null && !toFocus.isEnabled()) {
            return;
        }
        if (this.focusedInteractable != null) {
            this.focusedInteractable.onLeaveFocus(direction, this.focusedInteractable);
        }
        Interactable previous = this.focusedInteractable;
        this.focusedInteractable = toFocus;
        if (toFocus != null) {
            toFocus.onEnterFocus(direction, previous);
        }
        this.invalidate();
    }

    @Override
    public void setStrictFocusChange(boolean strictFocusChange) {
        this.strictFocusChange = strictFocusChange;
    }

    @Override
    public void setEnableDirectionBasedMovements(boolean enableDirectionBasedMovements) {
        this.enableDirectionBasedMovements = enableDirectionBasedMovements;
    }

    @Override
    public synchronized Theme getTheme() {
        if (this.theme != null) {
            return this.theme;
        }
        if (this.getTextGUI() != null) {
            return this.getTextGUI().getTheme();
        }
        return null;
    }

    @Override
    public synchronized void setTheme(Theme theme) {
        this.theme = theme;
        this.invalidate();
    }

    @Override
    public MenuBar getMenuBar() {
        return this.contentHolder.getMenuBar();
    }

    @Override
    public void setMenuBar(MenuBar menuBar) {
        this.contentHolder.setMenuBar(menuBar);
    }

    protected void addBasePaneListener(BasePaneListener<T> basePaneListener) {
        this.listeners.addIfAbsent(basePaneListener);
    }

    protected void removeBasePaneListener(BasePaneListener<T> basePaneListener) {
        this.listeners.remove(basePaneListener);
    }

    protected List<BasePaneListener<T>> getBasePaneListeners() {
        return this.listeners;
    }

    private static class EmptyMenuBar
    extends MenuBar {
        private EmptyMenuBar() {
        }

        @Override
        public boolean isInvalid() {
            return false;
        }

        @Override
        public synchronized void onAdded(Container container) {
        }

        @Override
        public synchronized void onRemoved(Container container) {
        }

        @Override
        public boolean isEmptyMenuBar() {
            return true;
        }
    }

    protected class ContentHolder
    extends AbstractComposite<Container> {
        private MenuBar menuBar = new EmptyMenuBar();

        ContentHolder() {
        }

        private void setMenuBar(MenuBar menuBar) {
            if (menuBar == null) {
                menuBar = new EmptyMenuBar();
            }
            if (this.menuBar != menuBar) {
                menuBar.onAdded(this);
                this.menuBar.onRemoved(this);
                this.menuBar = menuBar;
                if (AbstractBasePane.this.focusedInteractable == null) {
                    AbstractBasePane.this.setFocusedInteractable(menuBar.nextFocus(null));
                }
                this.invalidate();
            }
        }

        private MenuBar getMenuBar() {
            return this.menuBar;
        }

        @Override
        public boolean isInvalid() {
            return super.isInvalid() || this.menuBar.isInvalid();
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.menuBar.invalidate();
        }

        @Override
        public void updateLookupMap(InteractableLookupMap interactableLookupMap) {
            super.updateLookupMap(interactableLookupMap);
            this.menuBar.updateLookupMap(interactableLookupMap);
        }

        @Override
        public void setComponent(Component component) {
            if (this.getComponent() == component) {
                return;
            }
            AbstractBasePane.this.setFocusedInteractable(null);
            super.setComponent(component);
            if (AbstractBasePane.this.focusedInteractable == null && component instanceof Interactable) {
                AbstractBasePane.this.setFocusedInteractable((Interactable)component);
            } else if (AbstractBasePane.this.focusedInteractable == null && component instanceof Container) {
                AbstractBasePane.this.setFocusedInteractable(((Container)component).nextFocus(null));
            }
        }

        @Override
        public boolean removeComponent(Component component) {
            boolean removed = super.removeComponent(component);
            if (removed) {
                AbstractBasePane.this.focusedInteractable = null;
            }
            return removed;
        }

        @Override
        public TextGUI getTextGUI() {
            return AbstractBasePane.this.getTextGUI();
        }

        @Override
        protected ComponentRenderer<Container> createDefaultRenderer() {
            return new ComponentRenderer<Container>(){

                @Override
                public TerminalSize getPreferredSize(Container component) {
                    Component subComponent = ContentHolder.this.getComponent();
                    if (subComponent == null) {
                        return TerminalSize.ZERO;
                    }
                    return subComponent.getPreferredSize();
                }

                @Override
                public void drawComponent(TextGUIGraphics graphics, Container component) {
                    Component subComponent;
                    if (!(ContentHolder.this.menuBar instanceof EmptyMenuBar)) {
                        int menuBarHeight = ContentHolder.this.menuBar.getPreferredSize().getRows();
                        TextGUIGraphics menuGraphics = graphics.newTextGraphics(TerminalPosition.TOP_LEFT_CORNER, graphics.getSize().withRows(menuBarHeight));
                        ContentHolder.this.menuBar.draw(menuGraphics);
                        graphics = graphics.newTextGraphics(TerminalPosition.TOP_LEFT_CORNER.withRelativeRow(menuBarHeight), graphics.getSize().withRelativeRows(-menuBarHeight));
                    }
                    if ((subComponent = ContentHolder.this.getComponent()) == null) {
                        return;
                    }
                    subComponent.draw(graphics);
                }
            };
        }

        @Override
        public TerminalPosition toGlobal(TerminalPosition position) {
            return AbstractBasePane.this.toGlobal(position);
        }

        @Override
        public TerminalPosition toBasePane(TerminalPosition position) {
            return position;
        }

        @Override
        public BasePane getBasePane() {
            return AbstractBasePane.this;
        }
    }
}

