/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.graphics;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.graphics.ThemeStyle;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.ComponentRenderer;
import com.googlecode.lanterna.gui2.WindowDecorationRenderer;
import com.googlecode.lanterna.gui2.WindowPostRenderer;
import com.googlecode.lanterna.gui2.WindowShadowRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractTheme
implements Theme {
    private static final String STYLE_NORMAL = "";
    private static final String STYLE_PRELIGHT = "PRELIGHT";
    private static final String STYLE_SELECTED = "SELECTED";
    private static final String STYLE_ACTIVE = "ACTIVE";
    private static final String STYLE_INSENSITIVE = "INSENSITIVE";
    private static final Pattern STYLE_FORMAT = Pattern.compile("([a-zA-Z]+)(\\[([a-zA-Z0-9-_]+)])?");
    private final ThemeTreeNode rootNode = new ThemeTreeNode(Object.class, null);
    private final WindowPostRenderer windowPostRenderer;
    private final WindowDecorationRenderer windowDecorationRenderer;

    protected AbstractTheme(WindowPostRenderer postRenderer, WindowDecorationRenderer decorationRenderer) {
        this.windowPostRenderer = postRenderer;
        this.windowDecorationRenderer = decorationRenderer;
        this.rootNode.foregroundMap.put(STYLE_NORMAL, TextColor.ANSI.WHITE);
        this.rootNode.backgroundMap.put(STYLE_NORMAL, TextColor.ANSI.BLACK);
        this.classloadStandardRenderersForGraal();
    }

    private void classloadStandardRenderersForGraal() {
        WindowShadowRenderer.class.toString();
        Button.DefaultButtonRenderer.class.toString();
        Button.FlatButtonRenderer.class.toString();
        Button.BorderedButtonRenderer.class.toString();
    }

    protected boolean addStyle(String definition, String style, String value) {
        ThemeTreeNode node = this.getNode(definition);
        if (node == null) {
            return false;
        }
        node.apply(style, value);
        return true;
    }

    private ThemeTreeNode getNode(String definition) {
        try {
            if (definition == null || definition.trim().isEmpty()) {
                return this.getNode(Object.class);
            }
            return this.getNode(Class.forName(definition));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private ThemeTreeNode getNode(Class<?> definition) {
        if (definition == Object.class) {
            return this.rootNode;
        }
        ThemeTreeNode parent = this.getNode(definition.getSuperclass());
        if (parent.childMap.containsKey(definition)) {
            return (ThemeTreeNode)parent.childMap.get(definition);
        }
        ThemeTreeNode node = new ThemeTreeNode(definition, parent);
        parent.childMap.put(definition, node);
        return node;
    }

    @Override
    public ThemeDefinition getDefaultDefinition() {
        return new DefinitionImpl(this.rootNode);
    }

    @Override
    public ThemeDefinition getDefinition(Class<?> clazz) {
        LinkedList hierarchy = new LinkedList();
        while (clazz != null && clazz != Object.class) {
            hierarchy.addFirst(clazz);
            clazz = clazz.getSuperclass();
        }
        ThemeTreeNode node = this.rootNode;
        for (Class clazz2 : hierarchy) {
            if (!node.childMap.containsKey(clazz2)) break;
            node = (ThemeTreeNode)node.childMap.get(clazz2);
        }
        return new DefinitionImpl(node);
    }

    @Override
    public WindowPostRenderer getWindowPostRenderer() {
        return this.windowPostRenderer;
    }

    @Override
    public WindowDecorationRenderer getWindowDecorationRenderer() {
        return this.windowDecorationRenderer;
    }

    protected static Object instanceByClassName(String className) {
        if (className == null || className.trim().isEmpty()) {
            return null;
        }
        try {
            return Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> findRedundantDeclarations() {
        ArrayList<String> result = new ArrayList<String>();
        for (ThemeTreeNode node : this.rootNode.childMap.values()) {
            this.findRedundantDeclarations(result, node);
        }
        Collections.sort(result);
        return result;
    }

    private void findRedundantDeclarations(List<String> result, ThemeTreeNode node) {
        TextColor colorFromParent;
        TextColor color;
        String formattedStyle;
        for (String style : node.foregroundMap.keySet()) {
            formattedStyle = "[" + style + "]";
            if (formattedStyle.length() == 2) {
                formattedStyle = STYLE_NORMAL;
            }
            if (!(color = (TextColor)node.foregroundMap.get(style)).equals(colorFromParent = new StyleImpl(node.parent, style).getForeground())) continue;
            result.add(node.clazz.getName() + ".foreground" + formattedStyle);
        }
        for (String style : node.backgroundMap.keySet()) {
            formattedStyle = "[" + style + "]";
            if (formattedStyle.length() == 2) {
                formattedStyle = STYLE_NORMAL;
            }
            if (!(color = (TextColor)node.backgroundMap.get(style)).equals(colorFromParent = new StyleImpl(node.parent, style).getBackground())) continue;
            result.add(node.clazz.getName() + ".background" + formattedStyle);
        }
        for (String style : node.sgrMap.keySet()) {
            EnumSet<SGR> sgrsFromParent;
            EnumSet sgrs;
            formattedStyle = "[" + style + "]";
            if (formattedStyle.length() == 2) {
                formattedStyle = STYLE_NORMAL;
            }
            if (!(sgrs = (EnumSet)node.sgrMap.get(style)).equals(sgrsFromParent = new StyleImpl(node.parent, style).getSGRs())) continue;
            result.add(node.clazz.getName() + ".sgr" + formattedStyle);
        }
        for (ThemeTreeNode childNode : node.childMap.values()) {
            this.findRedundantDeclarations(result, childNode);
        }
    }

    private static class ThemeTreeNode {
        private final Class<?> clazz;
        private final ThemeTreeNode parent;
        private final Map<Class<?>, ThemeTreeNode> childMap;
        private final Map<String, TextColor> foregroundMap;
        private final Map<String, TextColor> backgroundMap;
        private final Map<String, EnumSet<SGR>> sgrMap;
        private final Map<String, Character> characterMap;
        private final Map<String, String> propertyMap;
        private Boolean cursorVisible;
        private String renderer;

        private ThemeTreeNode(Class<?> clazz, ThemeTreeNode parent) {
            this.clazz = clazz;
            this.parent = parent;
            this.childMap = new HashMap();
            this.foregroundMap = new HashMap<String, TextColor>();
            this.backgroundMap = new HashMap<String, TextColor>();
            this.sgrMap = new HashMap<String, EnumSet<SGR>>();
            this.characterMap = new HashMap<String, Character>();
            this.propertyMap = new HashMap<String, String>();
            this.cursorVisible = true;
            this.renderer = null;
        }

        private void apply(String style, String value) {
            value = value.trim();
            Matcher matcher = STYLE_FORMAT.matcher(style);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Unknown style declaration: " + style);
            }
            String styleComponent = matcher.group(1);
            String group = matcher.groupCount() > 2 ? matcher.group(3) : null;
            switch (styleComponent.toLowerCase().trim()) {
                case "foreground": {
                    this.foregroundMap.put(this.getCategory(group), this.parseValue(value));
                    break;
                }
                case "background": {
                    this.backgroundMap.put(this.getCategory(group), this.parseValue(value));
                    break;
                }
                case "sgr": {
                    this.sgrMap.put(this.getCategory(group), this.parseSGR(value));
                    break;
                }
                case "char": {
                    this.characterMap.put(this.getCategory(group), Character.valueOf(value.isEmpty() ? (char)' ' : value.charAt(0)));
                    break;
                }
                case "cursor": {
                    this.cursorVisible = Boolean.parseBoolean(value);
                    break;
                }
                case "property": {
                    this.propertyMap.put(this.getCategory(group), value.isEmpty() ? null : value.trim());
                    break;
                }
                case "renderer": {
                    this.renderer = value.trim().isEmpty() ? null : value.trim();
                    break;
                }
                case "postrenderer": 
                case "windowdecoration": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown style component \"" + styleComponent + "\" in style \"" + style + "\"");
                }
            }
        }

        private TextColor parseValue(String value) {
            return TextColor.Factory.fromString(value);
        }

        private EnumSet<SGR> parseSGR(String value) {
            value = value.trim();
            String[] sgrEntries = value.split(",");
            EnumSet<SGR> sgrSet = EnumSet.noneOf(SGR.class);
            for (String entry : sgrEntries) {
                if ((entry = entry.trim().toUpperCase()).isEmpty()) continue;
                try {
                    sgrSet.add(SGR.valueOf(entry));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Unknown SGR code \"" + entry + "\"", e);
                }
            }
            return sgrSet;
        }

        private String getCategory(String group) {
            if (group == null) {
                return AbstractTheme.STYLE_NORMAL;
            }
            for (String style : Arrays.asList(AbstractTheme.STYLE_ACTIVE, AbstractTheme.STYLE_INSENSITIVE, AbstractTheme.STYLE_PRELIGHT, AbstractTheme.STYLE_NORMAL, AbstractTheme.STYLE_SELECTED)) {
                if (!group.toUpperCase().equals(style)) continue;
                return style;
            }
            return group;
        }
    }

    private class StyleImpl
    implements ThemeStyle {
        private final ThemeTreeNode styleNode;
        private final String name;

        private StyleImpl(ThemeTreeNode node, String name) {
            this.styleNode = node;
            this.name = name;
        }

        @Override
        public TextColor getForeground() {
            ThemeTreeNode node = this.styleNode;
            while (node != null) {
                if (node.foregroundMap.containsKey(this.name)) {
                    return (TextColor)node.foregroundMap.get(this.name);
                }
                node = node.parent;
            }
            TextColor fallback = (TextColor)AbstractTheme.this.rootNode.foregroundMap.get(AbstractTheme.STYLE_NORMAL);
            if (fallback == null) {
                fallback = TextColor.ANSI.WHITE;
            }
            return fallback;
        }

        @Override
        public TextColor getBackground() {
            ThemeTreeNode node = this.styleNode;
            while (node != null) {
                if (node.backgroundMap.containsKey(this.name)) {
                    return (TextColor)node.backgroundMap.get(this.name);
                }
                node = node.parent;
            }
            TextColor fallback = (TextColor)AbstractTheme.this.rootNode.backgroundMap.get(AbstractTheme.STYLE_NORMAL);
            if (fallback == null) {
                fallback = TextColor.ANSI.BLACK;
            }
            return fallback;
        }

        @Override
        public EnumSet<SGR> getSGRs() {
            ThemeTreeNode node = this.styleNode;
            while (node != null) {
                if (node.sgrMap.containsKey(this.name)) {
                    return EnumSet.copyOf((EnumSet)node.sgrMap.get(this.name));
                }
                node = node.parent;
            }
            EnumSet<SGR> fallback = (EnumSet<SGR>)AbstractTheme.this.rootNode.sgrMap.get(AbstractTheme.STYLE_NORMAL);
            if (fallback == null) {
                fallback = EnumSet.noneOf(SGR.class);
            }
            return EnumSet.copyOf(fallback);
        }
    }

    private class DefinitionImpl
    implements ThemeDefinition {
        final ThemeTreeNode node;

        public DefinitionImpl(ThemeTreeNode node) {
            this.node = node;
        }

        @Override
        public ThemeStyle getNormal() {
            return new StyleImpl(this.node, AbstractTheme.STYLE_NORMAL);
        }

        @Override
        public ThemeStyle getPreLight() {
            return new StyleImpl(this.node, AbstractTheme.STYLE_PRELIGHT);
        }

        @Override
        public ThemeStyle getSelected() {
            return new StyleImpl(this.node, AbstractTheme.STYLE_SELECTED);
        }

        @Override
        public ThemeStyle getActive() {
            return new StyleImpl(this.node, AbstractTheme.STYLE_ACTIVE);
        }

        @Override
        public ThemeStyle getInsensitive() {
            return new StyleImpl(this.node, AbstractTheme.STYLE_INSENSITIVE);
        }

        @Override
        public ThemeStyle getCustom(String name) {
            return new StyleImpl(this.node, name);
        }

        @Override
        public ThemeStyle getCustom(String name, ThemeStyle defaultValue) {
            ThemeStyle customStyle = this.getCustom(name);
            if (customStyle == null) {
                customStyle = defaultValue;
            }
            return customStyle;
        }

        @Override
        public char getCharacter(String name, char fallback) {
            Character character = (Character)this.node.characterMap.get(name);
            if (character == null) {
                if (this.node == AbstractTheme.this.rootNode) {
                    return fallback;
                }
                return new DefinitionImpl(this.node.parent).getCharacter(name, fallback);
            }
            return character.charValue();
        }

        @Override
        public boolean isCursorVisible() {
            Boolean cursorVisible = this.node.cursorVisible;
            if (cursorVisible == null) {
                if (this.node == AbstractTheme.this.rootNode) {
                    return true;
                }
                return new DefinitionImpl(this.node.parent).isCursorVisible();
            }
            return cursorVisible;
        }

        @Override
        public boolean getBooleanProperty(String name, boolean defaultValue) {
            String propertyValue = (String)this.node.propertyMap.get(name);
            if (propertyValue == null) {
                if (this.node == AbstractTheme.this.rootNode) {
                    return defaultValue;
                }
                return new DefinitionImpl(this.node.parent).getBooleanProperty(name, defaultValue);
            }
            return Boolean.parseBoolean(propertyValue);
        }

        @Override
        public <T extends Component> ComponentRenderer<T> getRenderer(Class<T> type) {
            String rendererClass = this.node.renderer;
            if (rendererClass == null) {
                if (this.node == AbstractTheme.this.rootNode) {
                    return null;
                }
                return new DefinitionImpl(this.node.parent).getRenderer(type);
            }
            return (ComponentRenderer)AbstractTheme.instanceByClassName(rendererClass);
        }
    }
}

