/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util.visitor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.ITreeTraversal;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;

public class DepthFirstTraversal<T>
implements ITreeTraversal<T> {
    private final IDepthFirstTreeVisitor<T> m_visitor;
    private final Function<T, Collection<? extends T>> m_childrenSupplier;

    protected DepthFirstTraversal(IDepthFirstTreeVisitor<T> visitor, Function<T, Collection<? extends T>> childrenSupplier) {
        this.m_visitor = visitor;
        this.m_childrenSupplier = childrenSupplier;
    }

    @Override
    public TreeVisitResult traverse(T root) {
        return this.doVisitInternal(Assertions.assertNotNull(root), new HashSet(), 0, 0);
    }

    protected TreeVisitResult doVisitInternal(T toVisit, Set<T> alreadyVisited, int level, int index) {
        TreeVisitResult childResult;
        if (alreadyVisited.contains(toVisit)) {
            return TreeVisitResult.CONTINUE;
        }
        TreeVisitResult nextAction = this.m_visitor.preVisit(toVisit, level, index);
        alreadyVisited.add(toVisit);
        if (nextAction == TreeVisitResult.TERMINATE) {
            return TreeVisitResult.TERMINATE;
        }
        if (nextAction != TreeVisitResult.SKIP_SUBTREE && (childResult = this.visitChildren(toVisit, alreadyVisited, level + 1)) == TreeVisitResult.TERMINATE) {
            return TreeVisitResult.TERMINATE;
        }
        boolean continueVisit = this.m_visitor.postVisit(toVisit, level, index);
        if (!continueVisit) {
            return TreeVisitResult.TERMINATE;
        }
        return nextAction;
    }

    protected TreeVisitResult visitChildren(T parent, Set<T> alreadyVisited, int level) {
        Collection<T> children = this.m_childrenSupplier.apply(parent);
        if (CollectionUtility.isEmpty(children)) {
            return TreeVisitResult.CONTINUE;
        }
        int i = 0;
        for (T child : children) {
            TreeVisitResult nextAction;
            if (child == null) continue;
            if ((nextAction = this.doVisitInternal(child, alreadyVisited, level, i++)) == TreeVisitResult.TERMINATE) {
                return TreeVisitResult.TERMINATE;
            }
            if (nextAction != TreeVisitResult.SKIP_SIBLINGS) continue;
            return TreeVisitResult.CONTINUE;
        }
        return TreeVisitResult.CONTINUE;
    }
}

