/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util.visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.util.visitor.DepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;

public class CollectingVisitor<T>
extends DepthFirstTreeVisitor<T> {
    private final List<T> m_list = new ArrayList<T>();
    private final Predicate<T> m_filter;

    public CollectingVisitor() {
        this(null);
    }

    public CollectingVisitor(Predicate<T> filter) {
        this.m_filter = filter;
    }

    @Override
    public TreeVisitResult preVisit(T element, int level, int index) {
        if (this.accept(element)) {
            this.collect(element);
        }
        return TreeVisitResult.CONTINUE;
    }

    protected boolean accept(T element) {
        return this.m_filter == null || this.m_filter.test(element);
    }

    public void collect(T o) {
        this.m_list.add(o);
    }

    public List<T> getCollection() {
        return this.m_list;
    }
}

