/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util.event;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.scout.rt.platform.util.WeakEventListener;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;

public class UnsafeFastListenerList<LISTENER>
implements IFastListenerList<LISTENER> {
    private final List<Object> m_refs = new ArrayList<Object>();
    private final Map<LISTENER, Integer> m_indexes = new WeakHashMap<LISTENER, Integer>();

    @Override
    public boolean isEmpty() {
        return this.m_indexes.isEmpty();
    }

    @Override
    public void add(LISTENER listener) {
        this.add(listener, false);
    }

    @Override
    public void add(LISTENER listener, boolean weak) {
        if (this.m_indexes.containsKey(listener)) {
            return;
        }
        Object ref = weak || listener instanceof WeakEventListener ? new WeakReference<LISTENER>(listener) : listener;
        int i = this.m_refs.size();
        this.m_refs.add(ref);
        this.m_indexes.put(listener, i);
        this.maintain();
    }

    public void addAll(UnsafeFastListenerList<LISTENER> srcList) {
        for (Object ref : srcList.m_refs) {
            Object listener;
            if (ref instanceof WeakReference) {
                listener = ((Reference)ref).get();
                if (listener == null) continue;
                this.add(listener, true);
                continue;
            }
            listener = ref;
            if (listener == null) continue;
            this.add(listener, false);
        }
    }

    @Override
    public void remove(LISTENER listener) {
        Integer i = this.m_indexes.remove(listener);
        if (i != null) {
            this.m_refs.set(i, null);
        }
        this.maintain();
    }

    @Override
    public List<LISTENER> list() {
        this.maintain();
        if (this.m_indexes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LISTENER> result = new ArrayList<LISTENER>(this.m_indexes.size());
        int i = this.m_refs.size() - 1;
        while (i >= 0) {
            LISTENER listener = this.get(i);
            if (listener != null) {
                result.add(listener);
            }
            --i;
        }
        return result;
    }

    protected LISTENER get(int i) {
        Object ref = this.m_refs.get(i);
        if (ref instanceof WeakReference && (ref = ((Reference)ref).get()) == null) {
            this.m_refs.set(i, null);
        }
        return (LISTENER)ref;
    }

    protected void maintain() {
        Object ref;
        if (this.m_indexes.isEmpty()) {
            if (!this.m_refs.isEmpty()) {
                this.m_refs.clear();
            }
            return;
        }
        if (this.m_refs.size() <= 2 * this.m_indexes.size()) {
            return;
        }
        ArrayList<Object> tmp = new ArrayList<Object>(this.m_indexes.size());
        int i = 0;
        while (i < this.m_refs.size()) {
            ref = this.m_refs.get(i);
            if (ref instanceof WeakReference) {
                if (((WeakReference)ref).get() != null) {
                    tmp.add(ref);
                }
            } else if (ref != null) {
                tmp.add(ref);
            }
            ++i;
        }
        this.m_refs.clear();
        this.m_indexes.clear();
        if (!tmp.isEmpty()) {
            i = 0;
            while (i < tmp.size()) {
                ref = tmp.get(i);
                Object listener = ref instanceof WeakReference ? ((WeakReference)ref).get() : ref;
                this.m_refs.add(ref);
                this.m_indexes.put(listener, i);
                ++i;
            }
        }
    }

    protected List<Object> refs() {
        return this.m_refs;
    }

    protected Map<LISTENER, Integer> indexes() {
        return this.m_indexes;
    }
}

