/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util.concurrent;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.util.Assertions;

public final class GroupedSynchronizer<K, V> {
    public static final int DEFAULT_ROOT_LOCKS = 32;
    private final ConcurrentMap<K, V> m_locks = new ConcurrentHashMap();
    private final ReentrantReadWriteLock[] m_rootLocks;

    public GroupedSynchronizer() {
        this(32);
    }

    public GroupedSynchronizer(int numRootLocks) {
        this(numRootLocks, false);
    }

    public GroupedSynchronizer(boolean fair) {
        this(32, fair);
    }

    public GroupedSynchronizer(int numRootLocks, boolean fair) {
        this.m_rootLocks = new ReentrantReadWriteLock[numRootLocks];
        int i = 0;
        while (i < this.m_rootLocks.length) {
            this.m_rootLocks[i] = new ReentrantReadWriteLock(fair);
            ++i;
        }
    }

    public void runInGroupLock(K groupKey, Runnable task, Function<? super K, ? extends V> lockFactory) {
        this.acceptInGroupLock(groupKey, lockObj -> task.run(), lockFactory);
    }

    public void acceptInGroupLock(K groupKey, Consumer<? super V> task, Function<? super K, ? extends V> lockFactory) {
        this.applyInGroupLock(groupKey, lockObj -> {
            task.accept((Object)lockObj);
            return null;
        }, lockFactory);
    }

    public <R> R applyInGroupLock(K groupKey, Function<? super V, ? extends R> task, Function<? super K, ? extends V> lockFactory) {
        Assertions.assertNotNull(groupKey, "key may not be null", new Object[0]);
        Assertions.assertNotNull(task, "task may not be null", new Object[0]);
        Assertions.assertNotNull(lockFactory, "lockFactory may not be null", new Object[0]);
        ReentrantReadWriteLock rwl = this.lockFor(groupKey);
        ReentrantReadWriteLock.ReadLock rl = rwl.readLock();
        rl.lock();
        try {
            V lockGroup = this.computeLockGroupIfAbsent(groupKey, lockFactory);
            R r = this.runTaskInGroupLock(lockGroup, task, rl);
            return r;
        }
        finally {
            if (rwl.getReadHoldCount() > 0) {
                rl.unlock();
            }
        }
    }

    V computeLockGroupIfAbsent(K groupKey, Function<? super K, ? extends V> lockFactory) {
        return this.m_locks.computeIfAbsent((K)groupKey, lockFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R> R runTaskInGroupLock(V lockGroup, Function<? super V, ? extends R> task, ReentrantReadWriteLock.ReadLock rootLock) {
        V v = lockGroup;
        synchronized (v) {
            rootLock.unlock();
            return task.apply(lockGroup);
        }
    }

    ReentrantReadWriteLock lockFor(K key) {
        int hash = Objects.hashCode(key) & Integer.MAX_VALUE;
        int bucket = hash % this.numRootLocks();
        return this.m_rootLocks[bucket];
    }

    public V remove(K groupKey) {
        return this.remove(groupKey, null);
    }

    public V remove(K groupKey, Predicate<? super V> shouldRemove) {
        Assertions.assertNotNull(groupKey, "key may not be null", new Object[0]);
        ReentrantReadWriteLock.WriteLock rootLock = this.lockFor(groupKey).writeLock();
        rootLock.lock();
        try {
            V v = this.removeEntry(groupKey, shouldRemove);
            return v;
        }
        finally {
            rootLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V removeEntry(K groupKey, Predicate<? super V> shouldRemove) {
        Object lockGroup = this.m_locks.get(groupKey);
        if (lockGroup == null) {
            return null;
        }
        Object v = lockGroup;
        synchronized (v) {
            if (shouldRemove == null || shouldRemove.test(lockGroup)) {
                return this.m_locks.remove(groupKey);
            }
        }
        return null;
    }

    public Map<K, V> toMap() {
        return Collections.unmodifiableMap(this.m_locks);
    }

    public int numLockedRootLocks() {
        return (int)Stream.of(this.m_rootLocks).filter(ReentrantReadWriteLock::isWriteLocked).count();
    }

    public int numRootLocks() {
        return this.m_rootLocks.length;
    }

    public int size() {
        return this.m_locks.size();
    }
}

