/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentExpiringMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, ExpiringElement<V>> m_elementMap;
    private final long m_timeToLive;
    private final boolean m_touchOnGet;
    private final boolean m_touchOnIterate;
    private final int m_targetSize;
    private final int m_overflowSize;
    private final Lock m_validateSizeLock = new ReentrantLock();

    public ConcurrentExpiringMap() {
        this(1L, TimeUnit.MINUTES);
    }

    public ConcurrentExpiringMap(long timeToLiveDuration, TimeUnit timeToLiveUnit) {
        this(new ConcurrentHashMap(), timeToLiveUnit.toMillis(timeToLiveDuration), false, false, 0, 0);
    }

    public ConcurrentExpiringMap(long timeToLiveDuration, TimeUnit timeToLiveUnit, int targetSize) {
        this(new ConcurrentHashMap(), timeToLiveUnit.toMillis(timeToLiveDuration), true, false, targetSize, ConcurrentExpiringMap.defaultOverflowSize(targetSize));
    }

    public ConcurrentExpiringMap(ConcurrentExpiringMap<K, V> map, long timeToLiveDuration, TimeUnit timeToLiveUnit) {
        this(map.m_elementMap, timeToLiveUnit.toMillis(timeToLiveDuration), map.m_touchOnGet, map.m_touchOnIterate, map.m_targetSize, map.m_overflowSize);
    }

    public ConcurrentExpiringMap(ConcurrentExpiringMap<K, V> map, int targetSize) {
        this(map.m_elementMap, map.m_timeToLive, map.m_touchOnGet, map.m_touchOnIterate, targetSize, ConcurrentExpiringMap.sameRatioOverflowSize(targetSize, map.m_targetSize, map.m_overflowSize));
    }

    public ConcurrentExpiringMap(ConcurrentMap<K, ExpiringElement<V>> elementMap, long timeToLiveDurationMillis, boolean touchOnGet, int targetSize) {
        this(elementMap, timeToLiveDurationMillis, touchOnGet, false, targetSize, ConcurrentExpiringMap.defaultOverflowSize(targetSize));
    }

    public ConcurrentExpiringMap(ConcurrentMap<K, ExpiringElement<V>> elementMap, long timeToLiveDurationMillis, boolean touchOnGet, boolean touchOnIterate, int targetSize, int overflowSize) {
        this.m_elementMap = elementMap;
        this.m_timeToLive = timeToLiveDurationMillis;
        this.m_touchOnGet = touchOnGet;
        this.m_touchOnIterate = touchOnIterate;
        if (overflowSize > 0 && (targetSize <= 0 || targetSize >= overflowSize)) {
            throw new IllegalArgumentException("overflowSize is set but targetSize has no valid value");
        }
        this.m_targetSize = targetSize;
        this.m_overflowSize = overflowSize;
    }

    private static int defaultOverflowSize(int targetSize) {
        if (targetSize == 1) {
            return 2;
        }
        return targetSize * 3 / 2;
    }

    private static final int sameRatioOverflowSize(int targetSize, int oldTargetSize, int oldOverflowSize) {
        if (oldTargetSize == 0) {
            return ConcurrentExpiringMap.defaultOverflowSize(targetSize);
        }
        return targetSize * oldOverflowSize / oldTargetSize;
    }

    public ConcurrentMap<K, ExpiringElement<V>> getElementMap() {
        return this.m_elementMap;
    }

    public long getTimeToLive() {
        return this.m_timeToLive;
    }

    public boolean isTouchOnGet() {
        return this.m_touchOnGet;
    }

    public boolean isTouchOnIterate() {
        return this.m_touchOnIterate;
    }

    public int getTargetSize() {
        return this.m_targetSize;
    }

    public int getOverflowSize() {
        return this.m_overflowSize;
    }

    @Override
    public int size() {
        return this.m_elementMap.size();
    }

    @Override
    public boolean isEmpty() {
        return !this.newEntryIterator(false).hasNext();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean containsValue(Object value) {
        block2: {
            i = this.newEntryIterator(false);
            if (value != null) ** GOTO lbl11
            while (i.hasNext()) {
                e = i.next();
                if (e.getValue() != null) continue;
                return true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                e = i.next();
                if (!value.equals(e.getValue())) continue;
                return true;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getElement(key) != null;
    }

    @Override
    public V get(Object key) {
        ExpiringElement<V> e = this.getElement(key, this.m_touchOnGet);
        return e != null ? (V)e.getValue() : null;
    }

    public V getAndTouch(Object key) {
        ExpiringElement<V> e = this.getElement(key, true);
        return e != null ? (V)e.getValue() : null;
    }

    @Override
    public void clear() {
        this.m_elementMap.clear();
    }

    @Override
    public V put(K key, V value) {
        ExpiringElement<V> e = this.m_elementMap.put(key, this.createElement(value));
        this.validateSize();
        return this.extractValidElementValue(e);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.m_elementMap.put(e.getKey(), this.createElement(e.getValue()));
        }
        this.validateSize();
    }

    @Override
    public V remove(Object key) {
        ExpiringElement e = (ExpiringElement)this.m_elementMap.remove(key);
        return this.extractValidElementValue(e);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        ExpiringElement<V> e = this.m_elementMap.putIfAbsent(key, this.createElement(value));
        if (e != null && !this.isElementValid(e)) {
            if (this.m_elementMap.remove(key, e)) {
                this.execEntryEvicted(key, e.getValue());
            }
            e = this.m_elementMap.putIfAbsent(key, this.createElement(value));
        }
        this.validateSize();
        return e != null ? (V)e.getValue() : null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        V currValue;
        ExpiringElement<V> e = this.getElement(key);
        if (e != null && ((currValue = e.getValue()) == value || currValue != null && currValue.equals(value))) {
            return this.m_elementMap.remove(key, e);
        }
        return false;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        V currValue;
        ExpiringElement<V> currElement = this.getElement(key);
        if (currElement != null && ((currValue = currElement.getValue()) == oldValue || currValue != null && currValue.equals(oldValue))) {
            boolean success = this.m_elementMap.replace(key, currElement, this.createElement(newValue));
            this.validateSize();
            return success;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        ExpiringElement<V> e = this.getElement(key);
        if (e != null) {
            e = this.m_elementMap.replace(key, this.createElement(value));
        }
        this.validateSize();
        return e != null ? (V)e.getValue() : null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    protected ExpiringElement<V> createElement(V value) {
        return new ExpiringElement<V>(value);
    }

    protected ExpiringElement<V> getElement(Object key) {
        return this.getElement(key, false);
    }

    protected ExpiringElement<V> getElement(Object key, boolean touchOnReadAccess) {
        ExpiringElement<V> e = (ExpiringElement<V>)this.m_elementMap.get(key);
        if (e != null) {
            if (this.isElementValid(e)) {
                if (touchOnReadAccess) {
                    e = this.touch(key, e);
                }
                return e;
            }
            if (this.m_elementMap.remove(key, e)) {
                this.execEntryEvicted(key, e.getValue());
            }
        }
        return null;
    }

    protected ExpiringElement<V> touch(K key, ExpiringElement<V> e) {
        while (e != null) {
            if (this.m_elementMap.replace(key, e, this.createElement(e.getValue()))) {
                return e;
            }
            e = (ExpiringElement)this.m_elementMap.get(key);
        }
        return e;
    }

    protected boolean isElementValid(ExpiringElement<V> element) {
        return this.m_timeToLive <= 0L || element.getTimestamp() + this.m_timeToLive > System.currentTimeMillis();
    }

    protected V extractValidElementValue(ExpiringElement<V> element) {
        if (element != null && this.isElementValid(element)) {
            return element.getValue();
        }
        return null;
    }

    protected void validateSize() {
        if (this.m_validateSizeLock.tryLock()) {
            try {
                if (this.m_targetSize == 0 && this.m_timeToLive > 0L) {
                    this.evictExpiredEntries();
                } else if (this.m_targetSize > 0 && this.m_elementMap.size() >= this.m_overflowSize) {
                    this.evictOldestEntries();
                }
            }
            finally {
                this.m_validateSizeLock.unlock();
            }
        }
    }

    protected void evictExpiredEntries() {
        for (Map.Entry entry : this.m_elementMap.entrySet()) {
            Object key = entry.getKey();
            ExpiringElement element = (ExpiringElement)entry.getValue();
            if (this.isElementValid(element) || !this.m_elementMap.remove(key, element)) continue;
            this.execEntryEvicted(key, element.getValue());
        }
    }

    protected void evictOldestEntries() {
        TreeSet set = new TreeSet(new StableTimestampComparator());
        int counter = 0;
        for (Map.Entry entry : this.m_elementMap.entrySet()) {
            ((ExpiringElement)entry.getValue()).m_iterationIndex = counter;
            set.add(entry);
            ++counter;
        }
        int numberOfEntriesToEvict = set.size() - this.m_targetSize;
        while (numberOfEntriesToEvict > 0) {
            ExpiringElement element;
            Map.Entry oldestEntry = (Map.Entry)set.pollFirst();
            if (oldestEntry == null) break;
            Object key = oldestEntry.getKey();
            if (this.m_elementMap.remove(key, element = (ExpiringElement)oldestEntry.getValue())) {
                --numberOfEntriesToEvict;
                this.execEntryEvicted(key, element.getValue());
                continue;
            }
            if (this.m_elementMap.containsKey(key)) continue;
            --numberOfEntriesToEvict;
        }
    }

    protected void execEntryEvicted(K key, V value) {
    }

    protected Iterator<Map.Entry<K, V>> newEntryIterator(boolean touchOnAccess) {
        return new EntryIterator(touchOnAccess);
    }

    private final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final boolean m_touchOnAccess;
        private final Iterator<K> m_elementMapIterator;
        private Map.Entry<K, V> m_nextEntry;
        private Map.Entry<K, V> m_lastReturned;

        public EntryIterator(boolean touchOnAccess) {
            this.m_touchOnAccess = touchOnAccess;
            this.m_elementMapIterator = ConcurrentExpiringMap.this.m_elementMap.keySet().iterator();
            this.advance();
        }

        void advance() {
            block1: {
                while (this.m_elementMapIterator.hasNext()) {
                    Object key = this.m_elementMapIterator.next();
                    ExpiringElement element = ConcurrentExpiringMap.this.getElement(key, this.m_touchOnAccess);
                    if (element == null) continue;
                    this.m_nextEntry = new WriteThroughEntry(key, element.getValue());
                    break block1;
                }
                this.m_nextEntry = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.m_nextEntry != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.m_nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.m_lastReturned = this.m_nextEntry;
            this.advance();
            return this.m_lastReturned;
        }

        @Override
        public void remove() {
            if (this.m_lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentExpiringMap.this.remove(this.m_lastReturned.getKey());
            this.m_lastReturned = null;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return ConcurrentExpiringMap.this.newEntryIterator(ConcurrentExpiringMap.this.m_touchOnIterate);
        }

        @Override
        public boolean contains(Object o) {
            Object value;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object currentValue = ConcurrentExpiringMap.this.get(e.getKey());
            return currentValue == (value = e.getValue()) || currentValue != null && currentValue.equals(value);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentExpiringMap.this.remove(e.getKey()) != null;
        }

        @Override
        public int size() {
            return ConcurrentExpiringMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentExpiringMap.this.clear();
        }
    }

    public static class ExpiringElement<V> {
        private final long m_timestamp = System.currentTimeMillis();
        private final V m_value;
        private int m_iterationIndex;

        public ExpiringElement(V value) {
            this.m_value = value;
        }

        public long getTimestamp() {
            return this.m_timestamp;
        }

        public V getValue() {
            return this.m_value;
        }
    }

    private static class StableTimestampComparator<K, V>
    implements Comparator<Map.Entry<K, ExpiringElement<V>>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private StableTimestampComparator() {
        }

        @Override
        public int compare(Map.Entry<K, ExpiringElement<V>> o1, Map.Entry<K, ExpiringElement<V>> o2) {
            ExpiringElement<V> e1 = o1.getValue();
            ExpiringElement<V> e2 = o2.getValue();
            if (((ExpiringElement)e1).m_timestamp < ((ExpiringElement)e2).m_timestamp) {
                return -1;
            }
            if (((ExpiringElement)e1).m_timestamp > ((ExpiringElement)e2).m_timestamp) {
                return 1;
            }
            return Integer.compare(((ExpiringElement)e1).m_iterationIndex, ((ExpiringElement)e2).m_iterationIndex);
        }
    }

    private final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        private static final long serialVersionUID = 1L;

        WriteThroughEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V value) {
            Object v = super.setValue(value);
            ConcurrentExpiringMap.this.put(this.getKey(), value);
            return v;
        }
    }
}

