/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SleepUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SleepUtil.class);

    private SleepUtil() {
    }

    public static void sleepSafe(long time, TimeUnit unit) {
        try {
            Thread.sleep(unit.toMillis(time));
        }
        catch (InterruptedException e) {
            SleepUtil.restoreInterruptionStatus();
        }
    }

    public static void sleepElseLog(long time, TimeUnit unit) {
        SleepUtil.sleepElseLog(time, unit, "Interrupted", new Object[0]);
    }

    public static void sleepElseLog(long time, TimeUnit unit, String msg, Object ... msgArgs) {
        try {
            Thread.sleep(unit.toMillis(time));
        }
        catch (InterruptedException e) {
            SleepUtil.restoreInterruptionStatus();
            Object[] args = Arrays.copyOf(msgArgs, msgArgs.length + 1);
            args[args.length - 1] = e;
            LOG.info(msg, args);
        }
    }

    public static void sleepElseThrow(long time, TimeUnit unit) {
        SleepUtil.sleepElseThrow(time, unit, "Interrupted", new Object[0]);
    }

    public static void sleepElseThrow(long time, TimeUnit unit, String msg, Object ... msgArgs) {
        try {
            Thread.sleep(unit.toMillis(time));
        }
        catch (InterruptedException e) {
            SleepUtil.restoreInterruptionStatus();
            Object[] args = Arrays.copyOf(msgArgs, msgArgs.length + 1);
            args[args.length - 1] = e;
            throw new ThreadInterruptedError(msg, args);
        }
    }

    private static void restoreInterruptionStatus() {
        Thread.currentThread().interrupt();
    }
}

