/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class PathValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PathValidator.class);
    protected static final String PARENT_FOLDER_IDENTIFIER = "..";
    protected static final Pattern REGEX_FOLDER_SPLIT = Pattern.compile("\\\\|/");
    protected static final LazyValue<PathValidator> VALIDATOR = new LazyValue<PathValidator>(PathValidator.class);

    protected PathValidator() {
    }

    public static boolean isValid(String path) {
        try {
            VALIDATOR.get().validate(path);
            return true;
        }
        catch (Exception e) {
            LOG.info("Path validation failed", (Throwable)e);
            return false;
        }
    }

    public void validate(String path) {
        if (path == null || path.isEmpty()) {
            return;
        }
        String[] folders = REGEX_FOLDER_SPLIT.split(path);
        if (folders == null || folders.length < 1) {
            return;
        }
        String[] stringArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            if (PARENT_FOLDER_IDENTIFIER.equals(folder)) {
                throw new IllegalArgumentException("Invalid path: '" + path + "'. Parent paths are not allowed.");
            }
            ++n2;
        }
    }
}

