/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.NumberFormatProvider;
import org.eclipse.scout.rt.platform.util.date.DateFormatProvider;

public final class FormattingUtility {
    private FormattingUtility() {
    }

    public static String formatObject(Object o) {
        Locale loc = NlsLocale.get();
        String ret = null;
        if (o instanceof String) {
            ret = (String)o;
        } else if (o instanceof Date) {
            ret = BEANS.get(DateFormatProvider.class).getDateInstance(2, loc).format(o);
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)o);
            int hour = cal.get(10);
            int minute = cal.get(12);
            int second = cal.get(13);
            if (hour != 0 || minute != 0 || second != 0) {
                ret = BEANS.get(DateFormatProvider.class).getDateTimeInstance(3, 3, loc).format(o);
            }
        } else if (o instanceof Float || o instanceof Double || o instanceof BigDecimal) {
            DecimalFormat f = BEANS.get(NumberFormatProvider.class).getNumberInstance(loc);
            ((NumberFormat)f).setMinimumFractionDigits(2);
            ((NumberFormat)f).setMaximumFractionDigits(2);
            ret = f.format(o);
        } else if (o instanceof Number) {
            ret = BEANS.get(NumberFormatProvider.class).getNumberInstance(loc).format(o);
        } else if (o instanceof Boolean) {
            ret = (Boolean)o != false ? "X" : "";
        }
        return ret == null ? "" : ret;
    }
}

