/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.EventListener;
import org.eclipse.scout.rt.platform.events.IListenerListWithManagement;
import org.eclipse.scout.rt.platform.events.ISnapshotCollector;
import org.eclipse.scout.rt.platform.events.ListenerListRegistry;
import org.eclipse.scout.rt.platform.util.WeakEventListener;

public class EventListenerList
implements IListenerListWithManagement {
    private static final Object[] NULL_ARRAY = new Object[0];
    private final Object m_listenerListLock = new Object();
    private Object[] m_listenerList = NULL_ARRAY;

    public EventListenerList() {
        ListenerListRegistry.globalInstance().registerAsWeakReference(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSnapshot(ISnapshotCollector snapshot) {
        Object object = this.m_listenerListLock;
        synchronized (object) {
            int i = this.m_listenerList.length - 2;
            while (i >= 0) {
                Object o = this.m_listenerList[i + 1];
                if (o instanceof WeakReference) {
                    snapshot.add(null, ((Reference)o).get());
                } else {
                    snapshot.add(null, o);
                }
                i -= 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> T[] getListeners(Class<T> t) {
        Object object = this.m_listenerListLock;
        synchronized (object) {
            this.maintainListNoLocking();
            Object[] lList = this.m_listenerList;
            int n = this.getListenerCountNoLock(t);
            EventListener[] result = (EventListener[])Array.newInstance(t, n);
            int j = 0;
            int nullCount = 0;
            int i = lList.length - 2;
            while (i >= 0) {
                if (lList[i] == t) {
                    Object ref = lList[i + 1];
                    if (ref instanceof WeakReference) {
                        result[j] = (EventListener)((Reference)ref).get();
                        if (result[j] == null) {
                            ++nullCount;
                        }
                        ++j;
                    } else {
                        result[j++] = (EventListener)ref;
                    }
                }
                i -= 2;
            }
            if (nullCount > 0) {
                EventListener[] tmp = new EventListener[result.length - nullCount];
                j = 0;
                EventListener[] eventListenerArray = result;
                int n2 = result.length;
                int n3 = 0;
                while (n3 < n2) {
                    EventListener aResult = eventListenerArray[n3];
                    if (aResult != null) {
                        tmp[j++] = aResult;
                    }
                    ++n3;
                }
                result = tmp;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> int getListenerCount(Class<T> t) {
        Object object = this.m_listenerListLock;
        synchronized (object) {
            return this.getListenerCountNoLock(t);
        }
    }

    private <T extends EventListener> int getListenerCountNoLock(Class<T> t) {
        int count = 0;
        Object[] lList = this.m_listenerList;
        int i = 0;
        while (i < lList.length) {
            if (t == lList[i]) {
                ++count;
            }
            i += 2;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> void insertAtFront(Class<T> t, T listener) {
        if (listener == null) {
            return;
        }
        Object ref = listener instanceof WeakEventListener ? new WeakReference<T>(listener) : listener;
        Object object = this.m_listenerListLock;
        synchronized (object) {
            if (this.m_listenerList == NULL_ARRAY) {
                this.m_listenerList = new Object[]{t, ref};
            } else {
                int n = this.m_listenerList.length + 2;
                int k = 0;
                Object[] tmp = new Object[n];
                if (k < n - 2) {
                    System.arraycopy(this.m_listenerList, k, tmp, k + 2, n - 2 - k);
                }
                tmp[k] = t;
                tmp[k + 1] = ref;
                this.m_listenerList = tmp;
            }
            this.maintainListNoLocking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> void add(Class<T> t, T listener) {
        if (listener == null) {
            return;
        }
        Object ref = listener instanceof WeakEventListener ? new WeakReference<T>(listener) : listener;
        Object object = this.m_listenerListLock;
        synchronized (object) {
            if (this.m_listenerList == NULL_ARRAY) {
                this.m_listenerList = new Object[]{t, ref};
            } else {
                int i = this.m_listenerList.length;
                Object[] tmp = new Object[i + 2];
                System.arraycopy(this.m_listenerList, 0, tmp, 0, i);
                tmp[i] = t;
                tmp[i + 1] = ref;
                this.m_listenerList = tmp;
            }
            this.maintainListNoLocking();
        }
    }

    private <T extends EventListener> boolean removeInternal(Class<T> t, T listener) {
        if (listener == null) {
            return false;
        }
        int index = -1;
        int i = this.m_listenerList.length - 2;
        while (i >= 0) {
            if (this.m_listenerList[i] == t) {
                if (this.m_listenerList[i + 1] instanceof WeakReference) {
                    if (((Reference)this.m_listenerList[i + 1]).get() == listener) {
                        index = i;
                        break;
                    }
                } else if (this.m_listenerList[i + 1] == listener) {
                    index = i;
                    break;
                }
            }
            i -= 2;
        }
        if (index != -1) {
            Object[] tmp = new Object[this.m_listenerList.length - 2];
            System.arraycopy(this.m_listenerList, 0, tmp, 0, index);
            if (index < tmp.length) {
                System.arraycopy(this.m_listenerList, index + 2, tmp, index, tmp.length - index);
            }
            Object[] objectArray = this.m_listenerList = tmp.length == 0 ? NULL_ARRAY : tmp;
        }
        return index != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> void remove(Class<T> t, T listener) {
        if (listener == null) {
            return;
        }
        Object object = this.m_listenerListLock;
        synchronized (object) {
            this.removeInternal(t, listener);
            this.maintainListNoLocking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> void removeAll(Class<T> t, T listener) {
        if (listener == null) {
            return;
        }
        Object object = this.m_listenerListLock;
        synchronized (object) {
            while (this.removeInternal(t, listener)) {
            }
            this.maintainListNoLocking();
        }
    }

    private void maintainListNoLocking() {
        int j = 0;
        int nullCount = 0;
        int i = this.m_listenerList.length - 2;
        while (i >= 0) {
            Object ref = this.m_listenerList[i + 1];
            if (ref instanceof WeakReference) {
                if (((Reference)ref).get() == null) {
                    this.m_listenerList[i + 1] = null;
                    ++nullCount;
                }
            } else if (ref == null) {
                this.m_listenerList[i + 1] = null;
                ++nullCount;
            }
            i -= 2;
        }
        if (nullCount > 0) {
            Object[] tmp = new Object[this.m_listenerList.length - nullCount * 2];
            j = 0;
            int i2 = 0;
            while (i2 < this.m_listenerList.length) {
                if (this.m_listenerList[i2 + 1] != null) {
                    tmp[j] = this.m_listenerList[i2];
                    tmp[j + 1] = this.m_listenerList[i2 + 1];
                    j += 2;
                }
                i2 += 2;
            }
            this.m_listenerList = tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.m_listenerListLock;
        synchronized (object) {
            Object[] lList = this.m_listenerList;
            StringBuilder sb = new StringBuilder("EventListenerList: ");
            sb.append(lList.length / 2).append(" listeners: ");
            int i = 0;
            while (i <= lList.length - 2) {
                sb.append(" type ").append(((Class)lList[i]).getName());
                sb.append(" listener ").append(lList[i + 1]);
                i += 2;
            }
            return sb.toString();
        }
    }
}

