/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

public class CompositeObject
implements Comparable<CompositeObject>,
Serializable {
    private static final long serialVersionUID = 0L;
    private final Object[] m_value;

    public CompositeObject(Object ... a) {
        this.m_value = a != null && a.length == 1 && a[0] instanceof Collection ? ((Collection)a[0]).toArray() : a;
    }

    public int hashCode() {
        return Arrays.hashCode(this.m_value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeObject other = (CompositeObject)obj;
        return Arrays.equals(this.m_value, other.m_value);
    }

    public int getComponentCount() {
        if (this.m_value == null) {
            return 0;
        }
        return this.m_value.length;
    }

    public Object getComponent(int index) {
        return this.m_value[index];
    }

    public Object[] getComponents() {
        return this.m_value;
    }

    @Override
    public int compareTo(CompositeObject o) {
        Object[] me = this.m_value;
        Object[] other = o.m_value;
        if (me == null) {
            return -1;
        }
        if (other == null) {
            return 1;
        }
        int i = 0;
        while (i < me.length && i < other.length) {
            int c = this.compareImpl(me[i], other[i]);
            if (c != 0) {
                return c;
            }
            ++i;
        }
        return Integer.compare(me.length, other.length);
    }

    private int compareImpl(Object a, Object b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        return a.toString().compareTo(b.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (this.m_value != null && this.m_value.length > 0) {
            sb.append(String.valueOf(this.m_value[0]));
            if (this.m_value.length > 1) {
                int i = 1;
                while (i < this.m_value.length) {
                    sb.append(',');
                    sb.append(String.valueOf(this.m_value[i]));
                    ++i;
                }
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

