/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.util.Base64;
import org.eclipse.scout.rt.platform.util.StringUtility;

public final class Base64Utility {
    private Base64Utility() {
    }

    public static String encode(byte[] bytes) {
        return Base64Utility.encode(bytes, false);
    }

    public static String encodeUrlSafe(byte[] bytes) {
        return Base64Utility.encode(bytes, true);
    }

    public static String encode(byte[] bytes, boolean urlSafe) {
        if (urlSafe) {
            return Base64.getUrlEncoder().encodeToString(bytes);
        }
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] decode(String string) {
        return Base64Utility.decode(string, false);
    }

    public static byte[] decodeUrlSafe(String string) {
        return Base64Utility.decode(string, true);
    }

    public static byte[] decode(String string, boolean urlSafe) {
        string = StringUtility.replaceNewLines(string, "");
        if (urlSafe) {
            return Base64.getUrlDecoder().decode(string);
        }
        return Base64.getDecoder().decode(string);
    }
}

