/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.security;

import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class MalwareScanner {
    private static final Logger LOG = LoggerFactory.getLogger(MalwareScanner.class);

    public void scan(BinaryResource res) {
        File f;
        block17: {
            byte[] expected;
            block15: {
                if (res == null) {
                    return;
                }
                f = null;
                expected = res.getContent();
                if (expected != null && expected.length != 0) break block15;
                IOUtility.deleteFile(f);
                return;
            }
            try {
                try {
                    byte[] actual;
                    f = IOUtility.createTempFile("malware-scan", ".tmp", expected);
                    Throwable throwable = null;
                    Object var6_7 = null;
                    try (FileInputStream in = new FileInputStream(f);){
                        actual = IOUtility.readBytes(in, expected.length);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    if (Arrays.equals(expected, actual)) break block17;
                    this.throwUnsafeResource(res);
                }
                catch (Exception e) {
                    this.throwUnsafeResource(res);
                    IOUtility.deleteFile(f);
                }
            }
            catch (Throwable throwable) {
                IOUtility.deleteFile(f);
                throw throwable;
            }
        }
        IOUtility.deleteFile(f);
    }

    protected void throwUnsafeResource(BinaryResource res) {
        LOG.info("detected unsafe resource '{}'", (Object)res.getFilename());
        throw new PlatformException("Resource '{}' is not safe", res.getFilename());
    }
}

