/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.nls;

import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.exception.ProcessingException;

@ApplicationScoped
public class NaturalCollatorProvider {
    private final ConcurrentMap<Locale, Collator> m_cache = new ConcurrentHashMap<Locale, Collator>();

    public Collator getInstance(Locale locale) {
        Collator tmp;
        Collator result = (Collator)this.m_cache.get(locale);
        if (result == null && (tmp = this.m_cache.putIfAbsent(locale, result = this.create(locale))) != null) {
            result = tmp;
        }
        return (Collator)result.clone();
    }

    protected Collator create(Locale locale) {
        Collator c = Collator.getInstance(locale);
        if (c instanceof RuleBasedCollator) {
            try {
                String origRules = ((RuleBasedCollator)c).getRules();
                return new RuleBasedCollator(this.replaceRules(origRules));
            }
            catch (ParseException e) {
                throw new ProcessingException("Collation rules cannot be parsed", new Object[]{e});
            }
        }
        return c;
    }

    protected String replaceRules(String origRules) {
        return origRules.replaceAll("<'_'", "<' ','-'<'_'");
    }
}

