/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.logger;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.platform.AnnotationFactory;
import org.eclipse.scout.rt.platform.BeanMetaData;
import org.eclipse.scout.rt.platform.IBeanManager;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.platform.logger.ILoggerSupport;
import org.eclipse.scout.rt.platform.logger.NullLoggerSupport;
import org.eclipse.scout.rt.platform.serialization.SerializationUtility;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.BeanUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public class LoggerPlatformListener
implements IPlatformListener {
    public static final String LOGGER_FACTORY_CLASS_STR_LOGBACK = "ch.qos.logback.classic.util.ContextSelectorStaticBinder";
    public static final String LOGGER_FACTORY_CLASS_STR_LOG4J = "org.slf4j.impl.Log4jLoggerFactory";
    public static final String LOGGER_FACTORY_CLASS_STR_JUL = "org.slf4j.impl.JDK14LoggerFactory";
    public static final String LOGGER_SUPPORT_PACKAGE_NAME_PREFIX = "org.eclipse.scout.rt.platform.logger.";
    public static final String LOGGER_SUPPORT_CLASS_NAME_LOGBACK = "org.eclipse.scout.rt.platform.logger.LogbackLoggerSupport";
    public static final String LOGGER_SUPPORT_CLASS_NAME_LOG4J = "org.eclipse.scout.rt.platform.logger.Log4jLoggerSupport";
    public static final String LOGGER_SUPPORT_CLASS_NAME_JUL = "org.eclipse.scout.rt.platform.logger.JulLoggerSupport";
    private static final Logger LOG = LoggerFactory.getLogger(LoggerPlatformListener.class);
    private final Map<String, String> m_loggerSupportByLoggerFactoryId = new HashMap<String, String>();

    public LoggerPlatformListener() {
        this.registerLoggerSupportMappings(this.m_loggerSupportByLoggerFactoryId);
    }

    @Override
    public void stateChanged(PlatformEvent event) {
        if (event.getState() == IPlatform.State.BeanManagerPrepared) {
            this.registerLoggerSupportBean(event.getSource().getBeanManager());
        }
    }

    protected void registerLoggerSupportMappings(Map<String, String> mapping) {
        mapping.put(LOGGER_FACTORY_CLASS_STR_LOGBACK, LOGGER_SUPPORT_CLASS_NAME_LOGBACK);
        mapping.put(LOGGER_FACTORY_CLASS_STR_LOG4J, LOGGER_SUPPORT_CLASS_NAME_LOG4J);
        mapping.put(LOGGER_FACTORY_CLASS_STR_JUL, LOGGER_SUPPORT_CLASS_NAME_JUL);
    }

    protected void registerLoggerSupportBean(IBeanManager beanManager) {
        ILoggerSupport loggerSupport = null;
        String loggerFactoryClassStr = null;
        try {
            StaticLoggerBinder loggerBinder = StaticLoggerBinder.getSingleton();
            loggerFactoryClassStr = loggerBinder.getLoggerFactoryClassStr();
            LOG.debug("Found slf4j logger factory [class={}, classStr={}]", (Object)loggerBinder.getLoggerFactory(), (Object)loggerFactoryClassStr);
            String loggerSupportFqcn = this.getLoggerSupportFqcn(loggerFactoryClassStr);
            LOG.debug("Determined scout logger support FQCN {}", (Object)loggerSupportFqcn);
            if (loggerSupportFqcn != null) {
                loggerSupport = this.createLoggerSupport(loggerSupportFqcn);
            }
        }
        catch (Exception | NoClassDefFoundError e) {
            LOG.warn("Could not determine or install factory speicific logger support. Falling back to {}", (Object)NullLoggerSupport.class.getName(), (Object)e);
        }
        if (loggerSupport == null) {
            loggerSupport = this.createNullLoggerSupport(loggerFactoryClassStr);
        }
        beanManager.registerBean(new BeanMetaData(ILoggerSupport.class, loggerSupport).withAnnotation(AnnotationFactory.createApplicationScoped()));
        LOG.info("Registered logger support {}", (Object)loggerSupport.getClass().getName());
    }

    protected String getLoggerSupportFqcn(String loggerFactoryId) {
        return this.m_loggerSupportByLoggerFactoryId.get(loggerFactoryId);
    }

    protected ILoggerSupport createLoggerSupport(String loggerSupportFqcn) throws ClassNotFoundException {
        Class<?> clazz = SerializationUtility.getClassLoader().loadClass(loggerSupportFqcn);
        Assertions.assertTrue(ILoggerSupport.class.isAssignableFrom(clazz));
        return (ILoggerSupport)ILoggerSupport.class.cast(BeanUtility.createInstance(clazz, new Object[0]));
    }

    protected ILoggerSupport createNullLoggerSupport(String loggerFactoryClassStr) {
        return new NullLoggerSupport(loggerFactoryClassStr);
    }
}

