/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.logger;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;

public class LevelRangeFilter
extends Filter<ILoggingEvent> {
    private Level m_levelMin;
    private Level m_levelMax;

    public FilterReply decide(ILoggingEvent event) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        if (event.getLevel().isGreaterOrEqual(this.m_levelMin) && this.m_levelMax.isGreaterOrEqual(event.getLevel())) {
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    public void setLevelMin(String levelMin) {
        this.m_levelMin = Level.toLevel((String)levelMin);
    }

    public void setLevelMax(String levelMax) {
        this.m_levelMax = Level.toLevel((String)levelMax);
    }

    public void start() {
        if (this.m_levelMin != null || this.m_levelMax != null) {
            if (this.m_levelMin == null) {
                this.m_levelMin = Level.TRACE;
            }
            if (this.m_levelMax == null) {
                this.m_levelMax = Level.ERROR;
            }
            super.start();
        }
    }
}

