/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.internal.JobFutureTask;
import org.eclipse.scout.rt.platform.job.internal.JobListenerWithFilter;
import org.eclipse.scout.rt.platform.job.listener.IJobListener;
import org.eclipse.scout.rt.platform.job.listener.JobEvent;
import org.eclipse.scout.rt.platform.util.IAdaptable;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;

@Bean
public class JobListeners {
    private final List<JobListenerWithFilter> m_globalListeners = new CopyOnWriteArrayList<JobListenerWithFilter>();

    IRegistrationHandle add(Predicate<JobEvent> filter, IJobListener listener) {
        IFuture[] futures = this.getFilteredFutures(filter);
        if (futures != null) {
            return this.addLocalListener(filter, listener, futures);
        }
        return this.addGlobalListener(filter, listener);
    }

    protected IRegistrationHandle addGlobalListener(Predicate<JobEvent> filter, IJobListener listener) {
        JobListenerWithFilter globalListener = new JobListenerWithFilter(listener, filter);
        this.m_globalListeners.add(globalListener);
        return () -> {
            boolean bl = this.m_globalListeners.remove(globalListener);
        };
    }

    protected IRegistrationHandle addLocalListener(Predicate<JobEvent> filter, IJobListener listener, IFuture[] futures) {
        ArrayList<IRegistrationHandle> registrations = new ArrayList<IRegistrationHandle>(futures.length);
        IFuture[] iFutureArray = futures;
        int n = futures.length;
        int n2 = 0;
        while (n2 < n) {
            IFuture future = iFutureArray[n2];
            registrations.add(future.addListener(filter, listener));
            ++n2;
        }
        return () -> {
            for (IRegistrationHandle registration : registrations) {
                registration.dispose();
            }
        };
    }

    public void notifyListeners(JobEvent eventToFire) {
        this.notifyGlobalListeners(eventToFire);
        this.notifyLocalListeners(eventToFire);
    }

    public void notifyGlobalListeners(JobEvent eventToFire) {
        for (JobListenerWithFilter globalListener : this.m_globalListeners) {
            globalListener.changed(eventToFire);
        }
    }

    public void notifyLocalListeners(JobEvent eventToFire) {
        JobFutureTask future = (JobFutureTask)eventToFire.getData().getFuture();
        if (future == null) {
            return;
        }
        for (JobListenerWithFilter localListener : future.getListeners()) {
            localListener.changed(eventToFire);
        }
    }

    protected IFuture[] getFilteredFutures(Predicate<JobEvent> filter) {
        if (filter instanceof IAdaptable) {
            return ((IAdaptable)((Object)filter)).getAdapter(IFuture[].class);
        }
        return null;
    }
}

