/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import java.util.Date;
import org.eclipse.scout.rt.platform.job.JobState;
import org.eclipse.scout.rt.platform.job.internal.IRejectableRunnable;
import org.eclipse.scout.rt.platform.job.internal.JobFutureTask;
import org.eclipse.scout.rt.platform.job.internal.JobManager;
import org.quartz.Calendar;
import org.quartz.spi.OperableTrigger;

public class FutureRunner<RESULT>
implements IRejectableRunnable {
    private final JobFutureTask<RESULT> m_futureTask;
    private final JobManager m_jobManager;
    private final OperableTrigger m_trigger;

    public FutureRunner(JobManager jobManager, JobFutureTask<RESULT> futureTask) {
        this.m_jobManager = jobManager;
        this.m_futureTask = futureTask;
        this.m_trigger = futureTask.getTrigger();
    }

    @Override
    public void run() {
        this.m_futureTask.run();
        if (this.m_futureTask.isDone()) {
            return;
        }
        this.m_futureTask.changeState(JobState.PENDING);
        this.m_trigger.executionComplete(null, null);
        this.applyMisfire(this.m_futureTask.getCalendar(), this.m_trigger);
        this.m_jobManager.getDelayedExecutor().schedule(() -> this.m_jobManager.competeForPermitAndExecute(this.m_futureTask, this), this.m_trigger.getNextFireTime());
    }

    @Override
    public void reject() {
        this.m_futureTask.reject();
    }

    protected void applyMisfire(Calendar calendar, OperableTrigger trigger) {
        if (trigger.getMisfireInstruction() == -1) {
            return;
        }
        Date now = new Date();
        if (trigger.getNextFireTime().after(now)) {
            return;
        }
        trigger.updateAfterMisfire(calendar);
        if (trigger.getNextFireTime() == null) {
            trigger.setNextFireTime(now);
        }
    }
}

