/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.job.IExecutionSemaphore;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class ExecutionSemaphore
implements IExecutionSemaphore {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionSemaphore.class);
    private final ReentrantReadWriteLock.ReadLock m_readLock;
    private final ReentrantReadWriteLock.WriteLock m_writeLock;
    private volatile int m_permits = Integer.MAX_VALUE;
    private volatile boolean m_sealed;
    private final Deque<AcquisitionTask> m_queue = new ArrayDeque<AcquisitionTask>();
    private final Set<IFuture<?>> m_permitOwners = new HashSet();
    private final AtomicInteger m_executionPriority = new AtomicInteger(Integer.MAX_VALUE);

    public ExecutionSemaphore() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.m_readLock = lock.readLock();
        this.m_writeLock = lock.writeLock();
    }

    @Override
    public int getPermits() {
        return this.m_permits;
    }

    @Override
    public ExecutionSemaphore withPermits(int permits) {
        Assertions.assertFalse(this.m_sealed, "The number of permits cannot be changed because the semaphore is sealed [semaphore={}]", this);
        Assertions.assertGreaterOrEqual(permits, 0, "Number of semaphore permits must be '>= 0'", new Object[0]);
        this.m_permits = permits;
        AcquisitionTask acquisitionTask = this.assignOnePermit();
        while (acquisitionTask != null) {
            acquisitionTask.notifyPermitAcquired();
            acquisitionTask = this.assignOnePermit();
        }
        return this;
    }

    @Override
    public IExecutionSemaphore seal() {
        this.m_sealed = true;
        return this;
    }

    @Override
    public int getCompetitorCount() {
        this.m_readLock.lock();
        try {
            int n = this.m_queue.size() + this.m_permitOwners.size();
            return n;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public boolean isPermitOwner(IFuture<?> task) {
        this.m_readLock.lock();
        try {
            boolean bl = this.m_permitOwners.contains(task);
            return bl;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquire(IFuture<?> task, QueuePosition queuePosition) {
        this.assertSameSemaphore(task);
        Object acquisitionLock = new Object();
        AtomicBoolean waitingForPermit = new AtomicBoolean(true);
        this.compete(task, queuePosition, () -> {
            Object object2 = acquisitionLock;
            synchronized (object2) {
                if (waitingForPermit.get()) {
                    acquisitionLock.notify();
                } else {
                    this.release(task);
                }
            }
        });
        Object object = acquisitionLock;
        synchronized (object) {
            while (!this.isPermitOwner(task)) {
                try {
                    acquisitionLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    waitingForPermit.set(false);
                    throw new ThreadInterruptedError("Interrupted while competing for a permit", new Object[0]).withContextInfo("task", task.getJobInput().getName(), new Object[0]).withContextInfo("executionSemaphore", this, new Object[0]);
                }
            }
        }
    }

    protected boolean compete(IFuture<?> task, QueuePosition queuePosition, IPermitAcquiredCallback permitAcquiredCallback) {
        boolean permitFree;
        block9: {
            this.assertSameSemaphore(task);
            this.m_writeLock.lock();
            try {
                boolean bl = permitFree = this.m_permitOwners.size() < this.m_permits && this.m_queue.isEmpty();
                if (permitFree) {
                    this.m_permitOwners.add(task);
                    break block9;
                }
                switch (queuePosition) {
                    case HEAD: {
                        this.m_queue.offerFirst(new AcquisitionTask(task, permitAcquiredCallback));
                        break;
                    }
                    case TAIL: {
                        this.m_queue.offerLast(new AcquisitionTask(task, permitAcquiredCallback));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal queue position");
                    }
                }
            }
            finally {
                this.m_writeLock.unlock();
            }
        }
        if (permitFree) {
            permitAcquiredCallback.onPermitAcquired();
            return true;
        }
        return false;
    }

    protected void release(IFuture<?> permitOwner) {
        AcquisitionTask acquisitionTask;
        this.assertSameSemaphore(permitOwner);
        this.assertPermitOwner(permitOwner);
        this.m_writeLock.lock();
        try {
            this.m_permitOwners.remove(permitOwner);
            acquisitionTask = this.assignOnePermit();
        }
        finally {
            this.m_writeLock.unlock();
        }
        if (acquisitionTask != null) {
            acquisitionTask.notifyPermitAcquired();
        }
    }

    protected AcquisitionTask assignOnePermit() {
        this.m_writeLock.lock();
        try {
            if (this.m_permitOwners.size() >= this.m_permits) {
                return null;
            }
            AcquisitionTask acquisitionTask = this.m_queue.poll();
            if (acquisitionTask == null) {
                return null;
            }
            this.m_permitOwners.add(acquisitionTask.getCompetingTask());
            AcquisitionTask acquisitionTask2 = acquisitionTask;
            return acquisitionTask2;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    protected int computeNextLowerPriority() {
        return this.m_executionPriority.getAndDecrement();
    }

    protected void assertSameSemaphore(IFuture<?> task) {
        Assertions.assertSame(this, task.getJobInput().getExecutionSemaphore(), "Wrong execution semaphore [expected={}, actual={}]", this, task.getJobInput().getExecutionSemaphore());
    }

    protected void assertPermitOwner(IFuture<?> task) {
        Assertions.assertTrue(this.isPermitOwner(task), "Task does not own a permit [task={}]", task);
    }

    public String toString() {
        this.m_readLock.lock();
        try {
            ToStringBuilder builder = new ToStringBuilder(this);
            builder.attr("permitOwners", this.m_permitOwners);
            builder.attr("queue", this.m_queue);
            String string = builder.toString();
            return string;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    protected static ExecutionSemaphore get(JobInput input) {
        if (input.getExecutionSemaphore() == null) {
            return null;
        }
        Assertions.assertTrue(input.getExecutionSemaphore() instanceof ExecutionSemaphore, "Semaphore must be of type {} [semaphore={}]", ExecutionSemaphore.class.getName(), input.getExecutionSemaphore().getClass().getName());
        return (ExecutionSemaphore)input.getExecutionSemaphore();
    }

    protected static class AcquisitionTask {
        private final IFuture<?> m_competingTask;
        private final IPermitAcquiredCallback m_callback;

        public AcquisitionTask(IFuture<?> competingTask, IPermitAcquiredCallback callback) {
            this.m_competingTask = competingTask;
            this.m_callback = callback;
        }

        public IFuture<?> getCompetingTask() {
            return this.m_competingTask;
        }

        public void notifyPermitAcquired() {
            try {
                this.m_callback.onPermitAcquired();
            }
            catch (RuntimeException e) {
                LOG.error("Failed to notify new permit owner about permit acquisition [task={}]", this.m_competingTask, (Object)e);
            }
        }

        public String toString() {
            return String.format("Permit acquisition task for %s", this.m_competingTask);
        }
    }

    @FunctionalInterface
    public static interface IPermitAcquiredCallback {
        public void onPermitAcquired();
    }

    protected static enum QueuePosition {
        HEAD,
        TAIL;

    }
}

