/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.filter.future;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.filter.AndFilter;
import org.eclipse.scout.rt.platform.job.IExecutionSemaphore;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobState;
import org.eclipse.scout.rt.platform.job.filter.future.ExecutionHintFutureFilter;
import org.eclipse.scout.rt.platform.job.filter.future.ExecutionSemaphoreFutureFilter;
import org.eclipse.scout.rt.platform.job.filter.future.FutureFilter;
import org.eclipse.scout.rt.platform.job.filter.future.JobNameFutureFilter;
import org.eclipse.scout.rt.platform.job.filter.future.JobNameRegexFutureFilter;
import org.eclipse.scout.rt.platform.job.filter.future.JobStateFutureFilter;
import org.eclipse.scout.rt.platform.job.filter.future.RunContextFutureFilter;
import org.eclipse.scout.rt.platform.job.filter.future.SingleExecutionFutureFilter;
import org.eclipse.scout.rt.platform.util.Assertions;

@Bean
public class FutureFilterBuilder {
    private final List<Predicate<IFuture<?>>> m_andFilters = new ArrayList();

    public Predicate<IFuture<?>> toFilter() {
        switch (this.m_andFilters.size()) {
            case 0: {
                return f -> true;
            }
            case 1: {
                return this.m_andFilters.get(0);
            }
        }
        return new AndFilter(this.m_andFilters);
    }

    public FutureFilterBuilder andMatch(Predicate<IFuture<?>> filter) {
        this.m_andFilters.add(filter);
        return this;
    }

    public FutureFilterBuilder andMatchNot(Predicate<IFuture<?>> filter) {
        this.m_andFilters.add(Assertions.assertNotNull(filter, "Filter to negate must not be null", new Object[0]).negate());
        return this;
    }

    public FutureFilterBuilder andMatchName(String ... names) {
        this.andMatch(new JobNameFutureFilter(names));
        return this;
    }

    public FutureFilterBuilder andMatchNameRegex(Pattern regex) {
        this.andMatch(new JobNameRegexFutureFilter(regex));
        return this;
    }

    public FutureFilterBuilder andMatchFuture(IFuture ... futures) {
        this.andMatch(new FutureFilter(futures));
        return this;
    }

    public FutureFilterBuilder andMatchFuture(Collection<IFuture<?>> futures) {
        this.andMatch(new FutureFilter(futures));
        return this;
    }

    public <RESULT> FutureFilterBuilder andMatchFuture(List<IFuture<RESULT>> futures) {
        this.andMatch(new FutureFilter(futures.toArray(new IFuture[futures.size()])));
        return this;
    }

    public FutureFilterBuilder andMatchNotFuture(IFuture<?> ... futures) {
        this.andMatchNot(new FutureFilter(futures));
        return this;
    }

    public FutureFilterBuilder andMatchNotFuture(Collection<IFuture<?>> futures) {
        this.andMatchNot(new FutureFilter(futures));
        return this;
    }

    public <RESULT> FutureFilterBuilder andMatchNotFuture(List<IFuture<RESULT>> futures) {
        this.andMatchNot(new FutureFilter(futures.toArray(new IFuture[futures.size()])));
        return this;
    }

    public FutureFilterBuilder andMatchState(JobState ... states) {
        this.andMatch(new JobStateFutureFilter(states));
        return this;
    }

    public FutureFilterBuilder andMatchNotState(JobState ... states) {
        this.andMatchNot(new JobStateFutureFilter(states));
        return this;
    }

    public FutureFilterBuilder andMatchExecutionSemaphore(IExecutionSemaphore semaphore) {
        this.andMatch(new ExecutionSemaphoreFutureFilter(semaphore));
        return this;
    }

    public FutureFilterBuilder andAreSingleExecuting() {
        this.andMatch(SingleExecutionFutureFilter.INSTANCE);
        return this;
    }

    public FutureFilterBuilder andAreNotSingleExecuting() {
        this.andMatchNot(SingleExecutionFutureFilter.INSTANCE);
        return this;
    }

    public FutureFilterBuilder andMatchRunContext(Class<? extends RunContext> runContextClazz) {
        this.andMatch(new RunContextFutureFilter(runContextClazz));
        return this;
    }

    public FutureFilterBuilder andMatchExecutionHint(String hint) {
        this.andMatch(new ExecutionHintFutureFilter(hint));
        return this;
    }

    public FutureFilterBuilder andMatchNotExecutionHint(String hint) {
        this.andMatchNot(new ExecutionHintFutureFilter(hint));
        return this;
    }
}

