/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.quartz.Calendar;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

@Bean
public class ExecutionTrigger {
    private long m_now = System.currentTimeMillis();
    private Date m_startTime;
    private boolean m_startTimeSet;
    private Date m_endTime;
    private boolean m_endTimeSet;
    private Calendar m_calendar;
    private ScheduleBuilder<?> m_scheduleBuilder;

    public Date getNow() {
        return new Date(this.m_now);
    }

    public Date getStartTime() {
        return this.m_startTime != null ? this.m_startTime : this.getNow();
    }

    public ExecutionTrigger withStartIn(long duration, TimeUnit unit) {
        Assertions.assertFalse(this.m_startTimeSet, "StartTime already set", new Object[0]);
        ExecutionTrigger.assertDuration(this.m_now, duration, unit);
        this.m_startTime = new Date(this.m_now + unit.toMillis(duration));
        this.m_startTimeSet = true;
        return this;
    }

    public ExecutionTrigger withStartAt(Date startTime) {
        Assertions.assertFalse(this.m_startTimeSet, "StartTime already set", new Object[0]);
        this.m_startTime = startTime;
        this.m_startTimeSet = true;
        return this;
    }

    public Date getEndTime() {
        return this.m_endTime;
    }

    public ExecutionTrigger withEndIn(long duration, TimeUnit unit) {
        Assertions.assertFalse(this.m_endTimeSet, "EndTime already set", new Object[0]);
        ExecutionTrigger.assertDuration(this.m_now, duration, unit);
        this.m_endTime = new Date(this.m_now + unit.toMillis(duration));
        this.m_endTimeSet = true;
        return this;
    }

    public ExecutionTrigger withEndAt(Date endTime) {
        Assertions.assertFalse(this.m_endTimeSet, "EndTime already set", new Object[0]);
        this.m_endTime = endTime;
        this.m_endTimeSet = true;
        return this;
    }

    public Calendar getCalendar() {
        return this.m_calendar;
    }

    public ExecutionTrigger withModifiedByCalendar(Calendar calendar) {
        this.m_calendar = calendar;
        return this;
    }

    public ScheduleBuilder<?> getSchedule() {
        return this.m_scheduleBuilder;
    }

    public ExecutionTrigger withSchedule(ScheduleBuilder<? extends Trigger> scheduleBuilder) {
        this.m_scheduleBuilder = scheduleBuilder;
        return this;
    }

    public ExecutionTrigger copy() {
        ExecutionTrigger copy = BEANS.get(ExecutionTrigger.class);
        copy.m_now = this.m_now;
        copy.m_startTime = this.m_startTime != null ? new Date(this.m_startTime.getTime()) : null;
        copy.m_endTime = this.m_endTime != null ? new Date(this.m_endTime.getTime()) : null;
        copy.m_calendar = this.m_calendar != null ? (Calendar)this.m_calendar.clone() : null;
        copy.m_scheduleBuilder = TriggerBuilder.newTrigger().withSchedule(this.m_scheduleBuilder).build().getScheduleBuilder();
        return copy;
    }

    private static void assertDuration(long now, long duration, TimeUnit unit) {
        Assertions.assertNotEquals(unit, (Object)TimeUnit.NANOSECONDS, "Quartz Trigger does not support NANOSECONDS as temporal granularity", new Object[0]);
        Assertions.assertGreaterOrEqual(duration, 0L, "Invalid duration; must be >= 0 [duration={}]", duration);
        Assertions.assertGreaterOrEqual(now + duration, now, "Duration caused temporal overflow [duration={}, date={}]", duration, now + duration);
    }
}

