/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.jmx;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MBeanUtility {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanUtility.class);

    private MBeanUtility() {
    }

    public static ObjectName toJmxName(String domain, String name) {
        return MBeanUtility.toJmxName(domain, null, name);
    }

    public static ObjectName toJmxName(String domain, String type, String name) {
        try {
            if (StringUtility.isNullOrEmpty(type)) {
                return new ObjectName(String.valueOf(domain) + ":name=" + name);
            }
            return new ObjectName(String.valueOf(domain) + ":type=" + type + ",name=" + name);
        }
        catch (MalformedObjectNameException e) {
            throw new ProcessingException("Create ObjectName('{}', '{}', '{}')", domain, type, name, e);
        }
    }

    public static void register(ObjectName name, Object monitor) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (mbs.isRegistered(name)) {
                mbs.unregisterMBean(name);
            }
            mbs.registerMBean(monitor, name);
        }
        catch (JMException e) {
            LOG.warn("Could not register MBean '{}'", (Object)name, (Object)e);
        }
    }

    public static void unregister(ObjectName name) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (mbs.isRegistered(name)) {
                mbs.unregisterMBean(name);
            }
        }
        catch (JMException e) {
            LOG.warn("Could not unregister MBean '{}'", (Object)name, (Object)e);
        }
    }
}

