/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.inventory.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.scout.rt.platform.InjectBean;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.inventory.IClassInfo;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JandexClassInfo
implements IClassInfo {
    private static final Logger LOG = LoggerFactory.getLogger(JandexClassInfo.class);
    private static final String CONSTRUCTOR_NAME = "<init>";
    private final ClassInfo m_classInfo;
    private volatile Class<?> m_class;

    public JandexClassInfo(ClassInfo classInfo) {
        Assertions.assertNotNull(classInfo);
        this.m_classInfo = classInfo;
    }

    @Override
    public String name() {
        return this.m_classInfo.name().toString();
    }

    @Override
    public int flags() {
        return this.m_classInfo.flags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureClassLoaded() {
        if (this.m_class == null) {
            JandexClassInfo jandexClassInfo = this;
            synchronized (jandexClassInfo) {
                if (this.m_class == null) {
                    try {
                        this.m_class = Class.forName(this.name());
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError ex) {
                        throw new PlatformException("Error loading class '" + this.name() + "' with flags 0x" + Integer.toHexString(this.flags()), new Object[]{ex});
                    }
                }
            }
        }
    }

    @Override
    public boolean hasNoArgsConstructor() {
        return this.m_classInfo.hasNoArgsConstructor();
    }

    @Override
    public boolean hasInjectableConstructor() {
        List list = (List)this.m_classInfo.annotations().get(DotName.createSimple((String)InjectBean.class.getName()));
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (AnnotationInstance inst : list) {
            AnnotationTarget target = inst.target();
            if (AnnotationTarget.Kind.METHOD != target.kind() || !CONSTRUCTOR_NAME.equals(target.asMethod().name())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return this.m_classInfo.annotations().containsKey(DotName.createSimple((String)annotationType.getName()));
    }

    @Override
    public Object getAnnotationValue(Class<? extends Annotation> annotationType, String annotationParameterName) {
        List annotationInstances = (List)this.m_classInfo.annotations().get(DotName.createSimple((String)annotationType.getName()));
        if (CollectionUtility.isEmpty(annotationInstances)) {
            return null;
        }
        for (AnnotationInstance annotationInstance : annotationInstances) {
            AnnotationValue annotationValue;
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS || (annotationValue = annotationInstance.value(annotationParameterName)) == null) continue;
            return annotationValue.value();
        }
        return null;
    }

    @Override
    public Class<?> resolveClass() {
        this.ensureClassLoaded();
        return this.m_class;
    }

    @Override
    public boolean isInstanciable() {
        block5: {
            block6: {
                if (this.isAbstract() || this.isInterface() || !this.isPublic()) {
                    return false;
                }
                try {
                    if (this.m_classInfo.enclosingClass() == null) break block5;
                    if (Modifier.isStatic(this.flags())) break block6;
                    return false;
                }
                catch (Exception ex) {
                    LOG.warn("Could not resolve class [{}]", (Object)this.name(), (Object)ex);
                    return false;
                }
            }
            if (!Modifier.isPublic(this.flags())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.flags());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.flags());
    }

    @Override
    public boolean isInterface() {
        return Modifier.isInterface(this.flags());
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.flags());
    }

    @Override
    public boolean isSynthetic() {
        return (this.flags() & 0x1000) != 0;
    }

    @Override
    public boolean isAnnotation() {
        return (this.flags() & 0x2000) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.flags() & 0x4000) != 0;
    }

    public String toString() {
        return this.m_classInfo.toString();
    }

    public int hashCode() {
        return this.m_classInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JandexClassInfo other = (JandexClassInfo)obj;
        return !(this.m_classInfo == null ? other.m_classInfo != null : !this.m_classInfo.equals(other.m_classInfo));
    }
}

