/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.inventory;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.inventory.ClassInventory;
import org.eclipse.scout.rt.platform.inventory.IClassInfo;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteredClassInventory<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FilteredClassInventory.class);
    private final Predicate<IClassInfo> m_filter;
    private final Class<?> m_inventoryType;

    public FilteredClassInventory(Predicate<IClassInfo> filter, Class<?> clazz) {
        this.m_filter = filter;
        this.m_inventoryType = clazz;
    }

    public Set<Class<? extends T>> getClasses() {
        Set<IClassInfo> allClasses = this.findClasses();
        HashSet filteredClasses = new HashSet(allClasses.size());
        for (IClassInfo ci : allClasses) {
            if (!this.m_filter.test(ci)) continue;
            try {
                Class<?> clazz = ci.resolveClass();
                filteredClasses.add(clazz);
            }
            catch (Exception e) {
                LOG.error("Error loading class", (Throwable)e);
            }
        }
        return CollectionUtility.hashSet(filteredClasses);
    }

    protected Set<IClassInfo> findClasses() {
        return ClassInventory.get().getAllKnownSubClasses(this.getInventoryType());
    }

    protected Class<?> getInventoryType() {
        return this.m_inventoryType;
    }
}

