/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.internal;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BeanMetaData;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.IBeanInstanceProducer;
import org.eclipse.scout.rt.platform.internal.DefaultBeanInstanceProducer;
import org.eclipse.scout.rt.platform.util.Assertions;

public class BeanImplementor<T>
implements IBean<T> {
    private final Class<? extends T> m_beanClazz;
    private final Map<Class<? extends Annotation>, Annotation> m_beanAnnotations;
    private final T m_initialInstance;
    private boolean m_instanceAvailable;
    private IBeanInstanceProducer<T> m_producer;

    public BeanImplementor(BeanMetaData beanData) {
        this(beanData, new DefaultBeanInstanceProducer());
    }

    public BeanImplementor(BeanMetaData beanData, IBeanInstanceProducer<T> beanInstanceProducer) {
        this.m_beanClazz = Assertions.assertNotNull(beanData.getBeanClazz());
        this.m_beanAnnotations = new HashMap<Class<? extends Annotation>, Annotation>(Assertions.assertNotNull(beanData.getBeanAnnotations()));
        this.m_initialInstance = beanData.getInitialInstance();
        boolean bl = this.m_instanceAvailable = this.m_initialInstance != null;
        if (this.m_initialInstance != null && !this.hasAnnotation(ApplicationScoped.class)) {
            throw new IllegalArgumentException(String.format("Instance constructor only allows application scoped instances. Class '%s' does not have the '%s' annotation.", this.getBeanClazz().getName(), ApplicationScoped.class.getName()));
        }
        if (beanData.getProducer() != null) {
            this.m_producer = beanData.getProducer();
        } else if (!this.m_beanClazz.isInterface()) {
            this.m_producer = beanInstanceProducer;
        }
    }

    @Override
    public Class<? extends T> getBeanClazz() {
        return this.m_beanClazz;
    }

    @Override
    public <ANNOTATION extends Annotation> ANNOTATION getBeanAnnotation(Class<ANNOTATION> annotationClazz) {
        return (ANNOTATION)this.m_beanAnnotations.get(annotationClazz);
    }

    @Override
    public <ANNOTATION extends Annotation> boolean hasAnnotation(Class<ANNOTATION> annotation) {
        return this.getBeanAnnotation(annotation) != null;
    }

    @Override
    public Map<Class<? extends Annotation>, Annotation> getBeanAnnotations() {
        return new HashMap<Class<? extends Annotation>, Annotation>(this.m_beanAnnotations);
    }

    @Override
    public T getInitialInstance() {
        return this.m_initialInstance;
    }

    @Override
    public boolean isInstanceAvailable() {
        return this.m_instanceAvailable;
    }

    @Override
    public T getInstance() {
        if (this.m_initialInstance == null) {
            if (this.m_producer == null) {
                return null;
            }
            T instance = this.m_producer.produce(this);
            this.m_instanceAvailable = instance != null;
            return instance;
        }
        return this.m_initialInstance;
    }

    @Override
    public IBeanInstanceProducer<T> getBeanInstanceProducer() {
        return this.m_producer;
    }

    protected void dispose() {
        this.m_producer = null;
    }

    public int hashCode() {
        return this.m_beanClazz.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("IBean[");
        for (Annotation a : this.getBeanAnnotations().values()) {
            buf.append('@');
            buf.append(a.annotationType().getSimpleName());
            buf.append(' ');
        }
        buf.append(this.getBeanClazz().getName());
        T instance = this.getInitialInstance();
        if (instance != null) {
            buf.append(" with initial instance ").append(instance.toString());
        }
        buf.append(']');
        return buf.toString();
    }
}

