/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.platform.index.ISingleValueIndex;

public abstract class AbstractSingleValueIndex<INDEX, ELEMENT>
implements ISingleValueIndex<INDEX, ELEMENT> {
    private final Map<INDEX, ELEMENT> m_mapByIndex = new HashMap<INDEX, ELEMENT>();
    private final Map<ELEMENT, INDEX> m_mapByElement = new LinkedHashMap<ELEMENT, INDEX>();

    @Override
    public boolean addToIndex(ELEMENT element) {
        INDEX index;
        if (this.m_mapByElement.containsKey(element)) {
            this.removeFromIndex(element);
        }
        if ((index = this.calculateIndexFor(element)) == null) {
            return false;
        }
        this.m_mapByIndex.put(index, element);
        this.m_mapByElement.put(element, index);
        return true;
    }

    @Override
    public boolean removeFromIndex(ELEMENT element) {
        INDEX index = this.m_mapByElement.remove(element);
        if (index == null) {
            return false;
        }
        this.m_mapByIndex.remove(index);
        return true;
    }

    @Override
    public Set<INDEX> indexValues() {
        return new HashSet<INDEX>(this.m_mapByIndex.keySet());
    }

    @Override
    public List<ELEMENT> values() {
        return new ArrayList<ELEMENT>(this.m_mapByElement.keySet());
    }

    @Override
    public void clear() {
        this.m_mapByIndex.clear();
        this.m_mapByElement.clear();
    }

    @Override
    public boolean contains(ELEMENT element) {
        return this.m_mapByElement.containsKey(element);
    }

    @Override
    public Iterator<ELEMENT> iterator() {
        return this.values().iterator();
    }

    @Override
    public ELEMENT get(INDEX index) {
        return this.m_mapByIndex.get(index);
    }

    protected abstract INDEX calculateIndexFor(ELEMENT var1);
}

