/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.platform.index.IMultiValueIndex;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public abstract class AbstractMultiValuesIndex<INDEX, ELEMENT>
implements IMultiValueIndex<INDEX, ELEMENT> {
    private final Map<INDEX, List<ELEMENT>> m_mapByIndex = new HashMap<INDEX, List<ELEMENT>>();
    private final Map<ELEMENT, Set<INDEX>> m_mapByElement = new LinkedHashMap<ELEMENT, Set<INDEX>>();

    @Override
    public boolean addToIndex(ELEMENT element) {
        Set<INDEX> indexes;
        if (this.m_mapByElement.containsKey(element)) {
            this.removeFromIndex(element);
        }
        if ((indexes = this.calculateIndexesFor(element)) == null || indexes.isEmpty()) {
            return false;
        }
        for (INDEX index : indexes) {
            List elements = this.m_mapByIndex.computeIfAbsent(index, k -> new ArrayList());
            elements.add(element);
        }
        this.m_mapByElement.put(element, new HashSet<INDEX>(indexes));
        return true;
    }

    @Override
    public boolean removeFromIndex(ELEMENT element) {
        Set<INDEX> indexes = this.m_mapByElement.remove(element);
        if (indexes == null) {
            return false;
        }
        for (INDEX index : indexes) {
            List<ELEMENT> elements = this.m_mapByIndex.get(index);
            elements.remove(element);
            if (!elements.isEmpty()) continue;
            this.m_mapByIndex.remove(index);
        }
        return true;
    }

    @Override
    public Set<INDEX> indexValues() {
        return new HashSet<INDEX>(this.m_mapByIndex.keySet());
    }

    @Override
    public List<ELEMENT> values() {
        return new ArrayList<ELEMENT>(this.m_mapByElement.keySet());
    }

    @Override
    public void clear() {
        this.m_mapByIndex.clear();
        this.m_mapByElement.clear();
    }

    @Override
    public boolean contains(ELEMENT element) {
        return this.m_mapByElement.containsKey(element);
    }

    @Override
    public Iterator<ELEMENT> iterator() {
        return this.values().iterator();
    }

    @Override
    public List<ELEMENT> get(INDEX index) {
        return CollectionUtility.arrayList((Collection)this.m_mapByIndex.get(index));
    }

    protected abstract Set<INDEX> calculateIndexesFor(ELEMENT var1);
}

