/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.exception;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.scout.rt.platform.exception.IProcessingStatus;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.exception.ProcessingStatus;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.helpers.MessageFormatter;

public class ProcessingException
extends PlatformException {
    private static final long serialVersionUID = 1L;
    private ProcessingStatus m_status;

    public ProcessingException() {
        this("undefined", new Object[0]);
    }

    public ProcessingException(String message, Object ... args) {
        super(message, args);
        this.m_status = new ProcessingStatus(null, super.getDisplayMessage(), this, 0, 0x1000000);
    }

    public ProcessingException(IProcessingStatus status) {
        super(status.getBody(), new Object[]{status.getException()});
        this.withStatus(status);
    }

    @Override
    public ProcessingException withContextInfo(String name, Object value, Object ... valueArgs) {
        super.withContextInfo(name, value, valueArgs);
        return this;
    }

    public ProcessingException withTitle(String title, Object ... args) {
        this.m_status.setTitle(MessageFormatter.arrayFormat((String)title, (Object[])args).getMessage());
        return this;
    }

    public ProcessingException withCode(int code) {
        this.m_status.setCode(code);
        return this;
    }

    public ProcessingException withSeverity(int severity) {
        this.m_status.setSeverity(severity);
        return this;
    }

    public IProcessingStatus getStatus() {
        return this.m_status;
    }

    public ProcessingException withStatus(IProcessingStatus status) {
        Assertions.assertNotNull(status);
        ProcessingStatus processingStatus = this.m_status = status instanceof ProcessingStatus ? (ProcessingStatus)status : new ProcessingStatus(status);
        if (this.m_status.getException() == null) {
            this.m_status.setException(this);
        }
        return this;
    }

    @Override
    protected String getAdditionalContextInfos() {
        return StringUtility.join(", ", String.format("severity=%s", this.m_status.getSeverityName()), this.m_status.getCode() == 0 ? null : String.format("code=%s", this.m_status.getCode()));
    }

    public static StackTraceElement[] unionStackTrace(Throwable t) {
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        while (t != null) {
            list.addAll(0, Arrays.asList(t.getStackTrace()));
            t = t.getCause();
        }
        return list.toArray(new StackTraceElement[list.size()]);
    }

    @Override
    protected String extractMessageText() {
        if (this.m_status != null) {
            return this.m_status.getMessage();
        }
        return super.extractMessageText();
    }
}

