/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.exception;

import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.transaction.TransactionCancelledError;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.concurrent.FutureCancelledError;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandler.class);

    public void handle(Throwable t) {
        if (t instanceof TransactionCancelledError) {
            this.handleTransactionCancelledException((TransactionCancelledError)t);
        } else if (t instanceof ThreadInterruptedError) {
            this.handleInterruptedException((ThreadInterruptedError)t);
        } else if (t instanceof FutureCancelledError) {
            this.handleCancelledException((FutureCancelledError)t);
        } else if (t instanceof PlatformException) {
            PlatformException pe = (PlatformException)t;
            if (!pe.isConsumed()) {
                try {
                    this.handlePlatformException(pe);
                }
                finally {
                    pe.consume();
                }
            }
        } else {
            this.handleThrowable(t);
        }
    }

    protected void handleTransactionCancelledException(TransactionCancelledError e) {
        LOG.debug("Transaction cancelled", (Throwable)e);
    }

    protected void handleInterruptedException(ThreadInterruptedError e) {
        LOG.debug("Interruption", (Throwable)e);
    }

    protected void handleCancelledException(FutureCancelledError e) {
        LOG.debug("Cancellation", (Throwable)e);
    }

    protected void handlePlatformException(PlatformException e) {
        if (e instanceof VetoException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("", (Throwable)e);
            } else {
                LOG.info("{}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            }
        } else if (e instanceof ProcessingException) {
            switch (((ProcessingException)e).getStatus().getSeverity()) {
                case 1: 
                case 256: {
                    LOG.info("", (Throwable)e);
                    break;
                }
                case 65536: {
                    LOG.warn("", (Throwable)e);
                    break;
                }
                default: {
                    LOG.error("", (Throwable)e);
                    break;
                }
            }
        } else {
            LOG.error("", (Throwable)e);
        }
    }

    protected void handleThrowable(Throwable t) {
        LOG.error("{}:{}", new Object[]{t.getClass().getSimpleName(), ObjectUtility.nvl(t.getMessage(), "n/a"), t});
    }

    public static Throwable getRootCause(Throwable e) {
        if (e == null) {
            return null;
        }
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }
}

