/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.dataobject;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.dataobject.DoList;
import org.eclipse.scout.rt.platform.dataobject.DoValue;
import org.eclipse.scout.rt.platform.util.Assertions;

public final class DoPredicates {
    private DoPredicates() {
    }

    public static <VALUE, DO_NODE> Predicate<DO_NODE> eq(Function<DO_NODE, DoValue<VALUE>> accessor, VALUE value) {
        Assertions.assertNotNull(accessor, "accessor must not be null", new Object[0]);
        return n -> Objects.equals(((DoValue)accessor.apply(n)).get(), value);
    }

    public static <VALUE, DO_NODE> Predicate<DO_NODE> ne(Function<DO_NODE, DoValue<VALUE>> accessor, VALUE value) {
        return DoPredicates.eq(accessor, value).negate();
    }

    public static <VALUE, DO_NODE> Predicate<DO_NODE> in(Function<DO_NODE, DoValue<VALUE>> accessor, Collection<VALUE> values) {
        Assertions.assertNotNull(accessor, "accessor must not be null", new Object[0]);
        Assertions.assertNotNull(values, "values must not be null", new Object[0]);
        return n -> values.contains(((DoValue)accessor.apply(n)).get());
    }

    public static <VALUE, DO_NODE> Predicate<DO_NODE> notIn(Function<DO_NODE, DoValue<VALUE>> accessor, Collection<VALUE> values) {
        return DoPredicates.in(accessor, values).negate();
    }

    public static <DO_NODE, LIST_NODE> Predicate<DO_NODE> exists(Function<DO_NODE, DoList<LIST_NODE>> listAccessor, Predicate<LIST_NODE> predicate) {
        Assertions.assertNotNull(listAccessor, "list accessor must not be null", new Object[0]);
        Assertions.assertNotNull(predicate, "predicate must not be null", new Object[0]);
        return n -> ((DoList)listAccessor.apply(n)).findFirst(predicate) != null;
    }

    public static <DO_NODE, LIST_NODE> Predicate<DO_NODE> notExists(Function<DO_NODE, DoList<LIST_NODE>> listAccessor, Predicate<LIST_NODE> predicate) {
        return DoPredicates.exists(listAccessor, predicate).negate();
    }

    public static <DO_NODE, LIST_NODE> Predicate<DO_NODE> empty(Function<DO_NODE, DoList<LIST_NODE>> listAccessor) {
        Assertions.assertNotNull(listAccessor, "list accessor must not be null", new Object[0]);
        return n -> ((DoList)listAccessor.apply(n)).get().isEmpty();
    }

    public static <DO_NODE, LIST_NODE> Predicate<DO_NODE> notEmpty(Function<DO_NODE, DoList<LIST_NODE>> listAccessor) {
        return DoPredicates.empty(listAccessor).negate();
    }
}

