/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.dataobject;

import java.math.BigInteger;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.dataobject.DoValue;
import org.eclipse.scout.rt.platform.dataobject.IDataObjectMapper;
import org.eclipse.scout.rt.platform.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.dataobject.IValueFormatConstants;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

@ApplicationScoped
public class DataObjectHelper {
    protected IDataObjectMapper getDataObjectMapper() {
        return BEANS.get(IDataObjectMapper.class);
    }

    public Integer getIntegerAttribute(IDoEntity entity, String attributeName) {
        return TypeCastUtility.castValue(entity.get(attributeName), Integer.class);
    }

    public Double getDoubleAttribute(IDoEntity entity, String attributeName) {
        return TypeCastUtility.castValue(entity.get(attributeName), Double.class);
    }

    public BigInteger getBigIntegerAttribute(IDoEntity entity, String attributeName) {
        return TypeCastUtility.castValue(entity.get(attributeName), BigInteger.class);
    }

    public Date getDateAttribute(IDoEntity entity, String attributeName) {
        Object value = entity.get(attributeName);
        if (value instanceof String) {
            return IValueFormatConstants.parseDefaultDate.apply(value);
        }
        return TypeCastUtility.castValue(value, Date.class);
    }

    public UUID getUuidAttribute(IDoEntity entity, String attributeName) {
        Object value = entity.get(attributeName);
        if (value == null) {
            return null;
        }
        if (value instanceof UUID) {
            return (UUID)UUID.class.cast(value);
        }
        if (value instanceof String) {
            return UUID.fromString((String)value);
        }
        throw new IllegalArgumentException("Cannot convert value '" + value + "' to UUID");
    }

    public Locale getLocaleAttribute(IDoEntity entity, String attributeName) {
        Object value = entity.get(attributeName);
        if (value == null) {
            return null;
        }
        if (value instanceof Locale) {
            return (Locale)Locale.class.cast(value);
        }
        if (value instanceof String) {
            return Locale.forLanguageTag((String)String.class.cast(value));
        }
        throw new IllegalArgumentException("Cannot convert value '" + value + "' to Locale");
    }

    public IDoEntity getEntityAttribute(IDoEntity entity, String propertyName) {
        return entity.get(propertyName, IDoEntity.class);
    }

    public <T extends IDoEntity> T clone(T value) {
        if (value == null) {
            return null;
        }
        Class<?> valueType = value.getClass();
        IDataObjectMapper mapper = this.getDataObjectMapper();
        String clone = mapper.writeValue(value);
        return (T)((IDoEntity)mapper.readValue(clone, valueType));
    }

    public String toString(IDoEntity entity) {
        if (entity == null) {
            return Objects.toString(entity);
        }
        return this.getDataObjectMapper().writeValue(entity);
    }

    public <T> T assertValue(DoValue<T> doValue) {
        Assertions.assertNotNull(doValue);
        Assertions.assertTrue(doValue.exists(), "Missing mandatory attribute '{}'", doValue.getAttributeName());
        return Assertions.assertNotNull(doValue.get(), "Value of property '{}' must not be null", doValue.getAttributeName());
    }

    public String assertValueHasText(DoValue<String> doValue) {
        String value = this.assertValue(doValue);
        Assertions.assertTrue(StringUtility.hasText(value), "Value of property '{}' must have text", doValue.getAttributeName());
        return value;
    }
}

