/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.context;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.chain.callable.CallableChain;
import org.eclipse.scout.rt.platform.context.CorrelationId;
import org.eclipse.scout.rt.platform.context.CorrelationIdContextValueProvider;
import org.eclipse.scout.rt.platform.context.IRunContextChainInterceptor;
import org.eclipse.scout.rt.platform.context.IRunContextChainInterceptorProducer;
import org.eclipse.scout.rt.platform.context.PrinicpalContextValueProvider;
import org.eclipse.scout.rt.platform.context.PropertyMap;
import org.eclipse.scout.rt.platform.context.RunContextChainIntercepterRegistry;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.context.RunMonitorCancellableProcessor;
import org.eclipse.scout.rt.platform.exception.DefaultRuntimeExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.IExceptionTranslator;
import org.eclipse.scout.rt.platform.logger.DiagnosticContextValueProcessor;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.security.SubjectProcessor;
import org.eclipse.scout.rt.platform.transaction.ITransaction;
import org.eclipse.scout.rt.platform.transaction.ITransactionMember;
import org.eclipse.scout.rt.platform.transaction.TransactionProcessor;
import org.eclipse.scout.rt.platform.transaction.TransactionScope;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.IAdaptable;
import org.eclipse.scout.rt.platform.util.ThreadLocalProcessor;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;
import org.eclipse.scout.rt.platform.util.concurrent.Callables;
import org.eclipse.scout.rt.platform.util.concurrent.ICancellable;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;

@Bean
public class RunContext
implements IAdaptable {
    public static final ThreadLocal<RunContext> CURRENT = new ThreadLocal();
    protected RunMonitor m_runMonitor = BEANS.get(RunMonitor.class);
    protected RunMonitor m_parentRunMonitor;
    protected Subject m_subject;
    protected Locale m_locale;
    protected String m_correlationId;
    protected PropertyMap m_propertyMap = new PropertyMap();
    protected Map<ThreadLocal<?>, ThreadLocalProcessor<?>> m_threadLocalProcessors = new HashMap();
    protected Map<String, DiagnosticContextValueProcessor> m_diagnosticProcessors = new HashMap<String, DiagnosticContextValueProcessor>();
    protected TransactionScope m_transactionScope = TransactionScope.REQUIRED;
    protected ITransaction m_transaction;
    protected List<ITransactionMember> m_transactionMembers = new ArrayList<ITransactionMember>();
    protected List<IRunContextChainInterceptor<?>> m_interceptors = new ArrayList();

    @PostConstruct
    protected void initChainInterceptors() {
        List producers = BEANS.get(RunContextChainIntercepterRegistry.class).getRunContextInterceptorProducer(this.getClass());
        for (IRunContextChainInterceptorProducer producer : producers) {
            IRunContextChainInterceptor interceptor = producer.create();
            if (interceptor == null) continue;
            this.m_interceptors.add(interceptor);
        }
    }

    public void run(IRunnable runnable) {
        this.call(Callables.callable(runnable));
    }

    public <EXCEPTION extends Throwable> void run(IRunnable runnable, Class<? extends IExceptionTranslator<EXCEPTION>> exceptionTranslator) throws EXCEPTION {
        this.call(Callables.callable(runnable), exceptionTranslator);
    }

    public <RESULT> RESULT call(Callable<RESULT> callable) {
        return this.call(callable, DefaultRuntimeExceptionTranslator.class);
    }

    public <RESULT, EXCEPTION extends Throwable> RESULT call(Callable<RESULT> callable, Class<? extends IExceptionTranslator<EXCEPTION>> exceptionTranslator) throws EXCEPTION {
        ThreadInterrupter threadInterrupter = new ThreadInterrupter(Thread.currentThread(), this.m_runMonitor);
        try {
            RESULT RESULT = this.createCallableChain().call(callable);
            return RESULT;
        }
        catch (Throwable t) {
            throw BEANS.get(exceptionTranslator).translate(t);
        }
        finally {
            threadInterrupter.destroy();
        }
    }

    protected <RESULT> CallableChain<RESULT> createCallableChain() {
        CallableChain contributions = new CallableChain();
        this.interceptCallableChain(contributions);
        TransactionProcessor transactionProcessor = BEANS.get(TransactionProcessor.class).withCallerTransaction(this.m_transaction).withTransactionScope(this.m_transactionScope).withTransactionMembers(this.m_transactionMembers);
        return new CallableChain().add(new RunMonitorCancellableProcessor(this.m_parentRunMonitor, this.m_runMonitor)).add(new ThreadLocalProcessor<RunContext>(CURRENT, this)).add(new ThreadLocalProcessor<String>(CorrelationId.CURRENT, this.m_correlationId)).add(new ThreadLocalProcessor<RunMonitor>(RunMonitor.CURRENT, Assertions.assertNotNull(this.m_runMonitor))).add(new SubjectProcessor(this.m_subject)).add(new DiagnosticContextValueProcessor(BEANS.get(PrinicpalContextValueProvider.class))).add(new DiagnosticContextValueProcessor(BEANS.get(CorrelationIdContextValueProvider.class))).add(new ThreadLocalProcessor<Locale>(NlsLocale.CURRENT, this.m_locale)).add(new ThreadLocalProcessor<PropertyMap>(PropertyMap.CURRENT, this.m_propertyMap)).addAll(this.m_threadLocalProcessors.values()).addAll(contributions.asList()).addAll(this.m_diagnosticProcessors.values()).add(transactionProcessor).addAll(this.m_interceptors);
    }

    protected <RESULT> void interceptCallableChain(CallableChain<RESULT> callableChain) {
    }

    public RunMonitor getRunMonitor() {
        return this.m_runMonitor;
    }

    public RunContext withRunMonitor(RunMonitor runMonitor) {
        this.m_parentRunMonitor = null;
        this.m_runMonitor = Assertions.assertNotNull(runMonitor, "RunMonitor must not be null", new Object[0]);
        return this;
    }

    public RunMonitor getParentRunMonitor() {
        return this.m_parentRunMonitor;
    }

    public RunContext withParentRunMonitor(RunMonitor parentRunMonitor) {
        this.m_parentRunMonitor = parentRunMonitor;
        return this;
    }

    public Subject getSubject() {
        return this.m_subject;
    }

    public RunContext withSubject(Subject subject) {
        this.m_subject = subject;
        return this;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public RunContext withLocale(Locale locale) {
        this.m_locale = locale;
        return this;
    }

    public String getCorrelationId() {
        return this.m_correlationId;
    }

    public RunContext withCorrelationId(String correlationId) {
        this.m_correlationId = correlationId;
        return this;
    }

    public TransactionScope getTransactionScope() {
        return this.m_transactionScope;
    }

    public RunContext withTransactionScope(TransactionScope transactionScope) {
        this.m_transactionScope = transactionScope;
        return this;
    }

    public ITransaction getTransaction() {
        return this.m_transaction;
    }

    public RunContext withTransaction(ITransaction transaction) {
        this.m_transaction = transaction;
        return this;
    }

    public RunContext withTransactionMember(ITransactionMember transactionMember) {
        this.m_transactionMembers.add(transactionMember);
        return this;
    }

    public RunContext withoutTransactionMembers() {
        this.m_transactionMembers.clear();
        return this;
    }

    public <VALUE> VALUE getThreadLocal(ThreadLocal<VALUE> threadLocal) {
        ThreadLocalProcessor<?> processor = this.m_threadLocalProcessors.get(threadLocal);
        if (processor == null) {
            return null;
        }
        return (VALUE)processor.getValue();
    }

    public <THREAD_LOCAL> RunContext withThreadLocal(ThreadLocal<THREAD_LOCAL> threadLocal, THREAD_LOCAL value) {
        this.m_threadLocalProcessors.put(threadLocal, new ThreadLocalProcessor<THREAD_LOCAL>(threadLocal, value));
        return this;
    }

    public RunContext withDiagnostic(DiagnosticContextValueProcessor.IDiagnosticContextValueProvider provider) {
        this.m_diagnosticProcessors.put(provider.key(), new DiagnosticContextValueProcessor(provider));
        return this;
    }

    public RunContext withDiagnostics(Collection<? extends DiagnosticContextValueProcessor.IDiagnosticContextValueProvider> diagnosticContextValueProviders) {
        for (DiagnosticContextValueProcessor.IDiagnosticContextValueProvider iDiagnosticContextValueProvider : diagnosticContextValueProviders) {
            this.withDiagnostic(iDiagnosticContextValueProvider);
        }
        return this;
    }

    public PropertyMap getPropertyMap() {
        return this.m_propertyMap;
    }

    public <VALUE> VALUE getProperty(Object key) {
        return this.m_propertyMap.get(key);
    }

    public <VALUE> VALUE getPropertyOrDefault(Object key, VALUE defaultValue) {
        return this.m_propertyMap.getOrDefault(key, defaultValue);
    }

    public boolean containsProperty(Object key) {
        return this.m_propertyMap.contains(key);
    }

    public RunContext withProperty(Object key, Object value) {
        this.m_propertyMap.put(key, value);
        return this;
    }

    public RunContext withProperties(Map<?, ?> properties) {
        for (Map.Entry<?, ?> propertyEntry : properties.entrySet()) {
            this.withProperty(propertyEntry.getKey(), propertyEntry.getValue());
        }
        return this;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        this.interceptToStringBuilder(builder);
        return builder.toString();
    }

    protected void interceptToStringBuilder(ToStringBuilder builder) {
        builder.attr("subject", (Object)this.getSubject()).attr("locale", (Object)this.getLocale()).attr("cid", this.getCorrelationId()).attr("transactionScope", (Object)this.getTransactionScope()).ref("transaction", this.getTransaction()).ref("runMonitor", this.getRunMonitor()).ref("transactionMembers", this.m_transactionMembers).ref("threadLocalProcessors", this.m_threadLocalProcessors);
    }

    protected void copyValues(RunContext origin) {
        this.m_runMonitor = origin.m_runMonitor;
        this.m_parentRunMonitor = origin.m_parentRunMonitor;
        this.m_subject = origin.m_subject;
        this.m_locale = origin.m_locale;
        this.m_correlationId = origin.m_correlationId;
        this.m_propertyMap = new PropertyMap(origin.m_propertyMap);
        this.m_transactionScope = origin.m_transactionScope;
        this.m_transaction = origin.m_transaction;
        this.m_transactionMembers = new ArrayList<ITransactionMember>(origin.m_transactionMembers);
        this.m_threadLocalProcessors = new HashMap(origin.m_threadLocalProcessors);
        this.m_diagnosticProcessors = new HashMap<String, DiagnosticContextValueProcessor>(origin.m_diagnosticProcessors);
        this.m_interceptors = new ArrayList(origin.m_interceptors);
    }

    protected void fillCurrentValues() {
        RunContext currentRunContext = Assertions.assertNotNull(CURRENT.get());
        this.m_runMonitor = RunMonitor.CURRENT.get();
        this.m_subject = Subject.getSubject(AccessController.getContext());
        this.m_locale = NlsLocale.CURRENT.get();
        this.m_correlationId = CorrelationId.CURRENT.get();
        this.m_propertyMap = new PropertyMap(PropertyMap.CURRENT.get());
        this.m_transactionScope = currentRunContext.m_transactionScope;
        this.m_transaction = ITransaction.CURRENT.get();
        this.m_transactionMembers = new ArrayList<ITransactionMember>(currentRunContext.m_transactionMembers);
        this.m_diagnosticProcessors = new HashMap<String, DiagnosticContextValueProcessor>(currentRunContext.m_diagnosticProcessors);
        this.m_threadLocalProcessors = new HashMap(currentRunContext.m_threadLocalProcessors.size());
        for (ThreadLocalProcessor<?> threadLocalProcessor : currentRunContext.m_threadLocalProcessors.values()) {
            ThreadLocal<?> threadLocal = threadLocalProcessor.getThreadLocal();
            this.m_threadLocalProcessors.put(threadLocal, new ThreadLocalProcessor(threadLocal, threadLocal.get()));
        }
        for (IRunContextChainInterceptor iRunContextChainInterceptor : this.m_interceptors) {
            iRunContextChainInterceptor.fillCurrent();
        }
    }

    protected void fillEmpty() {
        for (IRunContextChainInterceptor<?> interceptor : this.m_interceptors) {
            interceptor.fillEmtpy();
        }
    }

    public RunContext copy() {
        RunContext copy = BEANS.get(RunContext.class);
        copy.copyValues(this);
        return copy;
    }

    @Override
    public <T> T getAdapter(Class<T> type) {
        return null;
    }

    private static class ThreadInterrupter
    implements ICancellable {
        private final RunMonitor m_monitor;
        private final AtomicBoolean m_cancelled = new AtomicBoolean();
        private volatile Thread m_thread;

        ThreadInterrupter(Thread thread, RunMonitor monitor) {
            this.m_thread = thread;
            this.m_monitor = monitor;
            this.m_monitor.registerCancellable(this);
        }

        @Override
        public boolean isCancelled() {
            return this.m_cancelled.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean interruptIfRunning) {
            if (!this.m_cancelled.compareAndSet(false, true)) {
                return false;
            }
            if (interruptIfRunning) {
                ThreadInterrupter threadInterrupter = this;
                synchronized (threadInterrupter) {
                    if (this.m_thread != null) {
                        this.m_thread.interrupt();
                    }
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void destroy() {
            this.m_monitor.unregisterCancellable(this);
            ThreadInterrupter threadInterrupter = this;
            synchronized (threadInterrupter) {
                this.m_thread = null;
            }
        }
    }
}

