/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.config;

import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.config.AbstractBinaryConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractClassConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractPortConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractPositiveIntegerConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractPositiveLongConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractSubjectConfigProperty;
import org.eclipse.scout.rt.platform.config.IConfigProperty;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDescriptionExporter {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigDescriptionExporter.class);
    private Predicate<IConfigProperty> m_filter;

    public static void main(String[] args) {
        Path outFile = args.length == 1 && StringUtility.hasText(args[0]) ? Paths.get(args[0], new String[0]).normalize() : null;
        new ConfigDescriptionExporter().exportToAdoc(outFile);
    }

    public void exportToAdoc() {
        this.exportToAdoc(null);
    }

    public void exportToAdoc(Path asciiDoctorTarget) {
        AsciiDoctorConfigWriter writer = BEANS.get(AsciiDoctorConfigWriter.class);
        if (asciiDoctorTarget != null) {
            writer.withTargetFile(asciiDoctorTarget);
        }
        this.exportUsing(writer);
    }

    public void exportUsing(IConfigPropertyDescriptionWriter writer) {
        LOG.info("Exporting config property descriptions using exporter '{}'.", (Object)Assertions.assertNotNull(writer).getClass().getName());
        List<IConfigProperty> allProperties = BEANS.all(IConfigProperty.class);
        allProperties.sort(Comparator.comparing(IConfigProperty::getKey));
        writer.accept(allProperties.stream().filter(this.filter().orElseGet(() -> p -> true)));
    }

    public Optional<Predicate<IConfigProperty>> filter() {
        return Optional.ofNullable(this.m_filter);
    }

    public ConfigDescriptionExporter withFilter(Predicate<IConfigProperty> filter) {
        this.m_filter = filter;
        return this;
    }

    public static class AsciiDoctorConfigWriter
    implements IConfigPropertyDescriptionWriter {
        private Path m_targetFile = Paths.get(System.getProperty("user.home"), "config_export", "config.adoc");

        @Override
        public void accept(Stream<IConfigProperty> configProperties) {
            StringBuilder adoc = this.asciiDoctorDescFor(configProperties);
            byte[] rawContent = StandardCharsets.UTF_8.encode(CharBuffer.wrap(adoc)).array();
            try {
                Files.createDirectories(this.targetFile().getParent(), new FileAttribute[0]);
                Files.write(this.targetFile(), rawContent, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                LOG.info("Config property description written to '{}'.", (Object)this.targetFile());
            }
            catch (IOException e) {
                LOG.error("Error writing to file '{}'.", (Object)this.targetFile(), (Object)e);
            }
        }

        protected StringBuilder asciiDoctorDescFor(Stream<IConfigProperty> configProperties) {
            AsciiDoctorTableBuilder builder = BEANS.get(AsciiDoctorTableBuilder.class);
            builder.withName("Config Properties").withColumn("Key", 2).withColumn("Description", 4).withColumn("Data Type", 1).withColumn("Kind", 1);
            configProperties.forEach(p -> {
                AsciiDoctorTableBuilder asciiDoctorTableBuilder2 = builder.withCell(String.valueOf('`') + p.getKey() + '`').withCell(p.description()).withCell(this.dataTypeOf((IConfigProperty<?>)p)).withCell("Config Property");
            });
            return builder.build();
        }

        protected String dataTypeOf(IConfigProperty<?> property) {
            if (property instanceof AbstractSubjectConfigProperty) {
                return "Subject name as " + String.class.getSimpleName();
            }
            if (property instanceof AbstractPortConfigProperty) {
                return String.valueOf(Integer.class.getSimpleName()) + " between 1 and 65535";
            }
            if (property instanceof AbstractBinaryConfigProperty) {
                return "Base64 encoded " + String.class.getSimpleName();
            }
            if (property instanceof AbstractClassConfigProperty) {
                Class type = TypeCastUtility.getGenericsParameterClass(property.getClass(), AbstractClassConfigProperty.class, 0);
                return "Fully qualified class name. The class must have '" + type.getName() + "' in its super hierarchy.";
            }
            Class type = TypeCastUtility.getGenericsParameterClass(property.getClass(), IConfigProperty.class, 0);
            if (type == null) {
                LOG.warn("Cannot calculate data type of property '{}'.", (Object)property.getClass().getName());
                return "?";
            }
            if (Integer.class == type && property instanceof AbstractPositiveIntegerConfigProperty || Long.class == type && property instanceof AbstractPositiveLongConfigProperty) {
                return String.valueOf(type.getSimpleName()) + " >= 0";
            }
            return type.getSimpleName();
        }

        public AsciiDoctorConfigWriter withTargetFile(Path newTargetFile) {
            this.m_targetFile = Assertions.assertNotNull(newTargetFile);
            return this;
        }

        public Path targetFile() {
            return this.m_targetFile;
        }
    }

    @Bean
    public static class AsciiDoctorTableBuilder {
        private final StringBuilder m_content = new StringBuilder(1024);
        private final Map<String, Integer> m_columns = new LinkedHashMap<String, Integer>();
        private String m_tableName;

        public AsciiDoctorTableBuilder withColumn(String name, int width) {
            Assertions.assertTrue(this.m_content.length() < 1);
            this.m_columns.put(name, width);
            return this;
        }

        public AsciiDoctorTableBuilder withName(String name) {
            this.m_tableName = name;
            return this;
        }

        public AsciiDoctorTableBuilder withCell(String text) {
            this.appendCell(text, this.m_content);
            return this;
        }

        protected String escape(String s) {
            if (s == null) {
                return "";
            }
            return StringUtility.replace(StringUtility.replace(StringUtility.replace(s, "|", "\\|"), "'", "`"), "\n", "\n\n");
        }

        private void appendCell(String cellText, StringBuilder collector) {
            collector.append('|').append(this.escape(cellText)).append("\n");
        }

        public StringBuilder build() {
            StringBuilder result = new StringBuilder();
            result.append("[cols=\"").append(CollectionUtility.format(this.m_columns.values(), ",", false)).append("\", options=\"header\"]\n");
            if (StringUtility.hasText(this.m_tableName)) {
                result.append('.').append(this.m_tableName).append("\n");
            }
            result.append("|===\n");
            for (String header : this.m_columns.keySet()) {
                this.appendCell(header, result);
            }
            result.append((CharSequence)this.m_content);
            result.append("|===\n");
            return result;
        }
    }

    @Bean
    @FunctionalInterface
    public static interface IConfigPropertyDescriptionWriter
    extends Consumer<Stream<IConfigProperty>> {
    }
}

