/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.terminal.swing.AWTTerminalFontConfiguration;
import com.googlecode.lanterna.terminal.swing.GraphicalTerminalImplementation;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorColorConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorDeviceConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalScrollController;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.util.Collections;

class AWTTerminalImplementation
extends GraphicalTerminalImplementation {
    private final Component component;
    private final AWTTerminalFontConfiguration fontConfiguration;

    AWTTerminalImplementation(Component component, AWTTerminalFontConfiguration fontConfiguration, TerminalSize initialTerminalSize, TerminalEmulatorDeviceConfiguration deviceConfiguration, TerminalEmulatorColorConfiguration colorConfiguration, TerminalScrollController scrollController) {
        super(initialTerminalSize, deviceConfiguration, colorConfiguration, scrollController);
        this.component = component;
        this.fontConfiguration = fontConfiguration;
        component.setMinimumSize(new Dimension(fontConfiguration.getFontWidth(), fontConfiguration.getFontHeight()));
        component.setFocusTraversalKeys(0, Collections.emptySet());
        component.setFocusTraversalKeys(1, Collections.emptySet());
        component.addKeyListener(new GraphicalTerminalImplementation.TerminalInputListener(this));
        component.addMouseListener(new GraphicalTerminalImplementation.TerminalMouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                AWTTerminalImplementation.this.component.requestFocusInWindow();
            }
        });
        component.addHierarchyListener(e -> {
            if (e.getChangeFlags() == 2L) {
                if (e.getChanged().isDisplayable()) {
                    this.onCreated();
                } else {
                    this.onDestroyed();
                }
            }
        });
    }

    public AWTTerminalFontConfiguration getFontConfiguration() {
        return this.fontConfiguration;
    }

    @Override
    protected int getFontHeight() {
        return this.fontConfiguration.getFontHeight();
    }

    @Override
    protected int getFontWidth() {
        return this.fontConfiguration.getFontWidth();
    }

    @Override
    protected int getHeight() {
        return this.component.getHeight();
    }

    @Override
    protected int getWidth() {
        return this.component.getWidth();
    }

    @Override
    protected Font getFontForCharacter(TextCharacter character) {
        return this.fontConfiguration.getFontForCharacter(character);
    }

    @Override
    protected boolean isTextAntiAliased() {
        return this.fontConfiguration.isAntiAliased();
    }

    @Override
    protected void repaint() {
        if (EventQueue.isDispatchThread()) {
            this.component.repaint();
        } else {
            EventQueue.invokeLater(this.component::repaint);
        }
    }

    @Override
    public KeyStroke readInput() {
        if (EventQueue.isDispatchThread()) {
            throw new UnsupportedOperationException("Cannot call SwingTerminal.readInput() on the AWT thread");
        }
        return super.readInput();
    }
}

