/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.input.MouseActionType;

public class MouseAction
extends KeyStroke {
    private final MouseActionType actionType;
    private final int button;
    private final TerminalPosition position;

    public MouseAction(MouseActionType actionType, int button, TerminalPosition position) {
        super(KeyType.MouseEvent, false, false);
        this.actionType = actionType;
        this.button = button;
        this.position = position;
    }

    public MouseActionType getActionType() {
        return this.actionType;
    }

    public int getButton() {
        return this.button;
    }

    public TerminalPosition getPosition() {
        return this.position;
    }

    public boolean isMouseDown() {
        return this.actionType == MouseActionType.CLICK_DOWN;
    }

    public boolean isMouseDrag() {
        return this.actionType == MouseActionType.DRAG;
    }

    public boolean isMouseMove() {
        return this.actionType == MouseActionType.MOVE;
    }

    public boolean isMouseUp() {
        return this.actionType == MouseActionType.CLICK_RELEASE;
    }

    @Override
    public String toString() {
        return "MouseAction{actionType=" + (Object)((Object)this.actionType) + ", button=" + this.button + ", position=" + this.position + '}';
    }
}

