/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.AbstractComponent;
import com.googlecode.lanterna.gui2.ComponentRenderer;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import java.util.EnumSet;
import java.util.List;

public class Label
extends AbstractComponent<Label> {
    private String[] lines = null;
    private Integer labelWidth = 0;
    private TerminalSize labelSize = TerminalSize.ZERO;
    private TextColor foregroundColor = null;
    private TextColor backgroundColor = null;
    private final EnumSet<SGR> additionalStyles = EnumSet.noneOf(SGR.class);

    public Label(String text) {
        this.setText(text);
    }

    protected void setLines(String[] lines) {
        this.lines = lines;
    }

    public synchronized void setText(String text) {
        this.setLines(this.splitIntoMultipleLines(text));
        this.labelSize = this.getBounds(this.lines, this.labelSize);
        this.invalidate();
    }

    public synchronized String getText() {
        if (this.lines.length == 0) {
            return "";
        }
        StringBuilder bob = new StringBuilder(this.lines[0]);
        for (int i = 1; i < this.lines.length; ++i) {
            bob.append("\n").append(this.lines[i]);
        }
        return bob.toString();
    }

    protected String[] splitIntoMultipleLines(String text) {
        return text.replace("\r", "").split("\n");
    }

    protected TerminalSize getBounds(String[] lines, TerminalSize currentBounds) {
        if (currentBounds == null) {
            currentBounds = TerminalSize.ZERO;
        }
        currentBounds = currentBounds.withRows(lines.length);
        if (this.labelWidth == null || this.labelWidth == 0) {
            int preferredWidth = 0;
            for (String line : lines) {
                int lineWidth = TerminalTextUtils.getColumnWidth(line);
                if (preferredWidth >= lineWidth) continue;
                preferredWidth = lineWidth;
            }
            currentBounds = currentBounds.withColumns(preferredWidth);
        } else {
            List<String> wordWrapped = TerminalTextUtils.getWordWrappedText(this.labelWidth, lines);
            currentBounds = currentBounds.withColumns(this.labelWidth).withRows(wordWrapped.size());
        }
        return currentBounds;
    }

    public synchronized Label setForegroundColor(TextColor foregroundColor) {
        this.foregroundColor = foregroundColor;
        return this;
    }

    public TextColor getForegroundColor() {
        return this.foregroundColor;
    }

    public synchronized Label setBackgroundColor(TextColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public TextColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public synchronized Label addStyle(SGR sgr) {
        this.additionalStyles.add(sgr);
        return this;
    }

    public synchronized Label removeStyle(SGR sgr) {
        this.additionalStyles.remove((Object)sgr);
        return this;
    }

    public synchronized Label setLabelWidth(Integer labelWidth) {
        this.labelWidth = labelWidth;
        return this;
    }

    public Integer getLabelWidth() {
        return this.labelWidth;
    }

    @Override
    protected ComponentRenderer<Label> createDefaultRenderer() {
        return new ComponentRenderer<Label>(){

            @Override
            public TerminalSize getPreferredSize(Label Label2) {
                return Label.this.labelSize;
            }

            @Override
            public void drawComponent(TextGUIGraphics graphics, Label component) {
                ThemeDefinition themeDefinition = component.getThemeDefinition();
                graphics.applyThemeStyle(themeDefinition.getNormal());
                if (Label.this.foregroundColor != null) {
                    graphics.setForegroundColor(Label.this.foregroundColor);
                }
                if (Label.this.backgroundColor != null) {
                    graphics.setBackgroundColor(Label.this.backgroundColor);
                }
                for (SGR sgr : Label.this.additionalStyles) {
                    graphics.enableModifiers(sgr);
                }
                String[] linesToDraw = component.getLabelWidth() == null ? component.lines : TerminalTextUtils.getWordWrappedText(graphics.getSize().getColumns(), component.lines).toArray(new String[0]);
                for (int row = 0; row < Math.min(graphics.getSize().getRows(), linesToDraw.length); ++row) {
                    String line = linesToDraw[row];
                    if (graphics.getSize().getColumns() >= Label.this.labelSize.getColumns()) {
                        graphics.putString(0, row, line);
                        continue;
                    }
                    int availableColumns = graphics.getSize().getColumns();
                    String fitString = TerminalTextUtils.fitString(line, availableColumns);
                    graphics.putString(0, row, fitString);
                }
            }
        };
    }
}

