/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.AbstractInteractableComponent;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.InteractableRenderer;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Button
extends AbstractInteractableComponent<Button> {
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private String label;

    public Button(String label) {
        this.setLabel(label);
    }

    public Button(String label, Runnable action) {
        this(label);
        this.listeners.add(button -> action.run());
    }

    @Override
    protected ButtonRenderer createDefaultRenderer() {
        return new DefaultButtonRenderer();
    }

    @Override
    public synchronized TerminalPosition getCursorLocation() {
        return this.getRenderer().getCursorLocation(this);
    }

    @Override
    public synchronized Interactable.Result handleKeyStroke(KeyStroke keyStroke) {
        if (this.isActivationStroke(keyStroke)) {
            this.triggerActions();
            return Interactable.Result.HANDLED;
        }
        return super.handleKeyStroke(keyStroke);
    }

    protected synchronized void triggerActions() {
        for (Listener listener : this.listeners) {
            listener.onTriggered(this);
        }
    }

    public final synchronized void setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("null label to a button is not allowed");
        }
        if (label.isEmpty()) {
            label = " ";
        }
        this.label = label;
        this.invalidate();
    }

    public void addListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener to a button is not allowed");
        }
        this.listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return "Button{" + this.label + "}";
    }

    public static class BorderedButtonRenderer
    implements ButtonRenderer {
        @Override
        public TerminalPosition getCursorLocation(Button component) {
            return null;
        }

        @Override
        public TerminalSize getPreferredSize(Button component) {
            return new TerminalSize(TerminalTextUtils.getColumnWidth(component.getLabel()) + 5, 4);
        }

        @Override
        public void drawComponent(TextGUIGraphics graphics, Button button) {
            ThemeDefinition themeDefinition = button.getThemeDefinition();
            graphics.applyThemeStyle(themeDefinition.getNormal());
            TerminalSize size = graphics.getSize();
            graphics.drawLine(1, 0, size.getColumns() - 3, 0, '\u2500');
            graphics.drawLine(1, size.getRows() - 2, size.getColumns() - 3, size.getRows() - 2, '\u2500');
            graphics.drawLine(0, 1, 0, size.getRows() - 3, '\u2502');
            graphics.drawLine(size.getColumns() - 2, 1, size.getColumns() - 2, size.getRows() - 3, '\u2502');
            graphics.setCharacter(0, 0, '\u250c');
            graphics.setCharacter(size.getColumns() - 2, 0, '\u2510');
            graphics.setCharacter(size.getColumns() - 2, size.getRows() - 2, '\u2518');
            graphics.setCharacter(0, size.getRows() - 2, '\u2514');
            graphics.drawLine(1, 1, size.getColumns() - 3, 1, ' ');
            if (button.isFocused()) {
                graphics.applyThemeStyle(themeDefinition.getActive());
            }
            graphics.putString(2, 1, TerminalTextUtils.fitString(button.getLabel(), size.getColumns() - 5));
            graphics.applyThemeStyle(themeDefinition.getInsensitive());
            graphics.drawLine(1, size.getRows() - 1, size.getColumns() - 1, size.getRows() - 1, ' ');
            graphics.drawLine(size.getColumns() - 1, 1, size.getColumns() - 1, size.getRows() - 2, ' ');
        }
    }

    public static class FlatButtonRenderer
    implements ButtonRenderer {
        @Override
        public TerminalPosition getCursorLocation(Button component) {
            return null;
        }

        @Override
        public TerminalSize getPreferredSize(Button component) {
            return new TerminalSize(TerminalTextUtils.getColumnWidth(component.getLabel()), 1);
        }

        @Override
        public void drawComponent(TextGUIGraphics graphics, Button button) {
            ThemeDefinition themeDefinition = button.getThemeDefinition();
            if (button.isFocused()) {
                graphics.applyThemeStyle(themeDefinition.getActive());
            } else {
                graphics.applyThemeStyle(themeDefinition.getInsensitive());
            }
            graphics.fill(' ');
            if (button.isFocused()) {
                graphics.applyThemeStyle(themeDefinition.getSelected());
            } else {
                graphics.applyThemeStyle(themeDefinition.getNormal());
            }
            graphics.putString(0, 0, button.getLabel());
        }
    }

    public static class DefaultButtonRenderer
    implements ButtonRenderer {
        @Override
        public TerminalPosition getCursorLocation(Button button) {
            if (button.getThemeDefinition().isCursorVisible()) {
                return new TerminalPosition(1 + this.getLabelShift(button, button.getSize()), 0);
            }
            return null;
        }

        @Override
        public TerminalSize getPreferredSize(Button button) {
            return new TerminalSize(Math.max(8, TerminalTextUtils.getColumnWidth(button.getLabel()) + 2), 1);
        }

        @Override
        public void drawComponent(TextGUIGraphics graphics, Button button) {
            ThemeDefinition themeDefinition = button.getThemeDefinition();
            if (button.isFocused()) {
                graphics.applyThemeStyle(themeDefinition.getActive());
            } else {
                graphics.applyThemeStyle(themeDefinition.getInsensitive());
            }
            graphics.fill(' ');
            graphics.setCharacter(0, 0, themeDefinition.getCharacter("LEFT_BORDER", '<'));
            graphics.setCharacter(graphics.getSize().getColumns() - 1, 0, themeDefinition.getCharacter("RIGHT_BORDER", '>'));
            if (button.isFocused()) {
                graphics.applyThemeStyle(themeDefinition.getActive());
            } else {
                graphics.applyThemeStyle(themeDefinition.getPreLight());
            }
            int labelShift = this.getLabelShift(button, graphics.getSize());
            graphics.setCharacter(1 + labelShift, 0, button.getLabel().charAt(0));
            if (TerminalTextUtils.getColumnWidth(button.getLabel()) == 1) {
                return;
            }
            if (button.isFocused()) {
                graphics.applyThemeStyle(themeDefinition.getSelected());
            } else {
                graphics.applyThemeStyle(themeDefinition.getNormal());
            }
            graphics.putString(1 + labelShift + 1, 0, button.getLabel().substring(1));
        }

        private int getLabelShift(Button button, TerminalSize size) {
            int availableSpace = size.getColumns() - 2;
            if (availableSpace <= 0) {
                return 0;
            }
            int labelShift = 0;
            int widthInColumns = TerminalTextUtils.getColumnWidth(button.getLabel());
            if (availableSpace > widthInColumns) {
                labelShift = (size.getColumns() - 2 - widthInColumns) / 2;
            }
            return labelShift;
        }
    }

    public static interface ButtonRenderer
    extends InteractableRenderer<Button> {
    }

    public static interface Listener {
        public void onTriggered(Button var1);
    }
}

