/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.AbstractBorder;
import com.googlecode.lanterna.gui2.Border;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import java.util.Arrays;
import java.util.List;

public class Borders {
    private Borders() {
    }

    public static Border singleLine() {
        return Borders.singleLine("");
    }

    public static Border singleLine(String title) {
        return new SingleLine(title, BorderStyle.Solid);
    }

    public static Border singleLineBevel() {
        return Borders.singleLineBevel("");
    }

    public static Border singleLineBevel(String title) {
        return new SingleLine(title, BorderStyle.Bevel);
    }

    public static Border singleLineReverseBevel() {
        return Borders.singleLineReverseBevel("");
    }

    public static Border singleLineReverseBevel(String title) {
        return new SingleLine(title, BorderStyle.ReverseBevel);
    }

    public static Border doubleLine() {
        return Borders.doubleLine("");
    }

    public static Border doubleLine(String title) {
        return new DoubleLine(title, BorderStyle.Solid);
    }

    public static Border doubleLineBevel() {
        return Borders.doubleLineBevel("");
    }

    public static Border doubleLineBevel(String title) {
        return new DoubleLine(title, BorderStyle.Bevel);
    }

    public static Border doubleLineReverseBevel() {
        return Borders.doubleLineReverseBevel("");
    }

    public static Border doubleLineReverseBevel(String title) {
        return new DoubleLine(title, BorderStyle.ReverseBevel);
    }

    public static void joinLinesWithFrame(TextGraphics graphics) {
        char neighbour;
        TextCharacter neighbourCharacter;
        TextCharacter borderCharacter;
        TerminalSize drawableArea = graphics.getSize();
        if (drawableArea.getRows() <= 2 || drawableArea.getColumns() <= 2) {
            return;
        }
        int upperRow = 0;
        int lowerRow = drawableArea.getRows() - 1;
        int leftRow = 0;
        int rightRow = drawableArea.getColumns() - 1;
        List<Character> junctionFromBelowSingle = Arrays.asList(Character.valueOf('\u2502'), Character.valueOf('\u257d'), Character.valueOf('\u2503'), Character.valueOf('\u253c'), Character.valueOf('\u256a'), Character.valueOf('\u2514'), Character.valueOf('\u2518'), Character.valueOf('\u2524'), Character.valueOf('\u251c'), Character.valueOf('\u2534'), Character.valueOf('\u2561'), Character.valueOf('\u255e'), Character.valueOf('\u2567'));
        List<Character> junctionFromBelowDouble = Arrays.asList(Character.valueOf('\u2551'), Character.valueOf('\u256c'), Character.valueOf('\u256b'), Character.valueOf('\u255a'), Character.valueOf('\u255d'), Character.valueOf('\u2563'), Character.valueOf('\u2560'), Character.valueOf('\u2569'), Character.valueOf('\u2562'), Character.valueOf('\u255f'), Character.valueOf('\u2568'));
        List<Character> junctionFromAboveSingle = Arrays.asList(Character.valueOf('\u2502'), Character.valueOf('\u257f'), Character.valueOf('\u2503'), Character.valueOf('\u253c'), Character.valueOf('\u256a'), Character.valueOf('\u250c'), Character.valueOf('\u2510'), Character.valueOf('\u2524'), Character.valueOf('\u251c'), Character.valueOf('\u252c'), Character.valueOf('\u2561'), Character.valueOf('\u255e'), Character.valueOf('\u2564'));
        List<Character> junctionFromAboveDouble = Arrays.asList(Character.valueOf('\u2551'), Character.valueOf('\u256c'), Character.valueOf('\u256b'), Character.valueOf('\u2554'), Character.valueOf('\u2557'), Character.valueOf('\u2563'), Character.valueOf('\u2560'), Character.valueOf('\u2566'), Character.valueOf('\u2562'), Character.valueOf('\u255f'), Character.valueOf('\u2565'));
        List<Character> junctionFromLeftSingle = Arrays.asList(Character.valueOf('\u2500'), Character.valueOf('\u257e'), Character.valueOf('\u2501'), Character.valueOf('\u253c'), Character.valueOf('\u256b'), Character.valueOf('\u2514'), Character.valueOf('\u250c'), Character.valueOf('\u2534'), Character.valueOf('\u252c'), Character.valueOf('\u251c'), Character.valueOf('\u2568'), Character.valueOf('\u2565'), Character.valueOf('\u255f'));
        List<Character> junctionFromLeftDouble = Arrays.asList(Character.valueOf('\u2550'), Character.valueOf('\u256c'), Character.valueOf('\u256a'), Character.valueOf('\u255a'), Character.valueOf('\u2554'), Character.valueOf('\u2569'), Character.valueOf('\u2566'), Character.valueOf('\u2560'), Character.valueOf('\u2567'), Character.valueOf('\u2564'), Character.valueOf('\u255e'));
        List<Character> junctionFromRightSingle = Arrays.asList(Character.valueOf('\u2500'), Character.valueOf('\u257c'), Character.valueOf('\u2501'), Character.valueOf('\u253c'), Character.valueOf('\u256b'), Character.valueOf('\u2518'), Character.valueOf('\u2510'), Character.valueOf('\u2534'), Character.valueOf('\u252c'), Character.valueOf('\u2524'), Character.valueOf('\u2568'), Character.valueOf('\u2565'), Character.valueOf('\u2562'));
        List<Character> junctionFromRightDouble = Arrays.asList(Character.valueOf('\u2550'), Character.valueOf('\u256c'), Character.valueOf('\u256a'), Character.valueOf('\u255d'), Character.valueOf('\u2557'), Character.valueOf('\u2569'), Character.valueOf('\u2566'), Character.valueOf('\u2563'), Character.valueOf('\u2567'), Character.valueOf('\u2564'), Character.valueOf('\u2561'));
        for (int column = 1; column < drawableArea.getColumns() - 1; ++column) {
            borderCharacter = graphics.getCharacter(column, upperRow);
            if (borderCharacter == null) continue;
            neighbourCharacter = graphics.getCharacter(column, upperRow + 1);
            if (neighbourCharacter != null) {
                neighbour = neighbourCharacter.getCharacterString().charAt(0);
                if (borderCharacter.is('\u2500')) {
                    if (junctionFromBelowSingle.contains(Character.valueOf(neighbour))) {
                        graphics.setCharacter(column, upperRow, borderCharacter.withCharacter('\u252c'));
                    } else if (junctionFromBelowDouble.contains(Character.valueOf(neighbour))) {
                        graphics.setCharacter(column, upperRow, borderCharacter.withCharacter('\u2565'));
                    }
                } else if (borderCharacter.is('\u2550')) {
                    if (junctionFromBelowSingle.contains(Character.valueOf(neighbour))) {
                        graphics.setCharacter(column, upperRow, borderCharacter.withCharacter('\u2564'));
                    } else if (junctionFromBelowDouble.contains(Character.valueOf(neighbour))) {
                        graphics.setCharacter(column, upperRow, borderCharacter.withCharacter('\u2566'));
                    }
                }
            }
            if ((borderCharacter = graphics.getCharacter(column, lowerRow)) == null || (neighbourCharacter = graphics.getCharacter(column, lowerRow - 1)) == null) continue;
            neighbour = neighbourCharacter.getCharacterString().charAt(0);
            if (borderCharacter.is('\u2500')) {
                if (junctionFromAboveSingle.contains(Character.valueOf(neighbour))) {
                    graphics.setCharacter(column, lowerRow, borderCharacter.withCharacter('\u2534'));
                    continue;
                }
                if (!junctionFromAboveDouble.contains(Character.valueOf(neighbour))) continue;
                graphics.setCharacter(column, lowerRow, borderCharacter.withCharacter('\u2568'));
                continue;
            }
            if (!borderCharacter.is('\u2550')) continue;
            if (junctionFromAboveSingle.contains(Character.valueOf(neighbour))) {
                graphics.setCharacter(column, lowerRow, borderCharacter.withCharacter('\u2567'));
                continue;
            }
            if (!junctionFromAboveDouble.contains(Character.valueOf(neighbour))) continue;
            graphics.setCharacter(column, lowerRow, borderCharacter.withCharacter('\u2569'));
        }
        for (int row = 1; row < drawableArea.getRows() - 1; ++row) {
            borderCharacter = graphics.getCharacter(leftRow, row);
            if (borderCharacter == null) continue;
            neighbourCharacter = graphics.getCharacter(leftRow + 1, row);
            if (neighbourCharacter != null) {
                neighbour = neighbourCharacter.getCharacterString().charAt(0);
                if (borderCharacter.is('\u2502')) {
                    if (junctionFromRightSingle.contains(Character.valueOf(neighbour))) {
                        graphics.setCharacter(leftRow, row, borderCharacter.withCharacter('\u251c'));
                    } else if (junctionFromRightDouble.contains(Character.valueOf(neighbour))) {
                        graphics.setCharacter(leftRow, row, borderCharacter.withCharacter('\u255e'));
                    }
                } else if (borderCharacter.is('\u2551')) {
                    if (junctionFromRightSingle.contains(Character.valueOf(neighbour))) {
                        graphics.setCharacter(leftRow, row, borderCharacter.withCharacter('\u255f'));
                    } else if (junctionFromRightDouble.contains(Character.valueOf(neighbour))) {
                        graphics.setCharacter(leftRow, row, borderCharacter.withCharacter('\u2560'));
                    }
                }
            }
            if ((borderCharacter = graphics.getCharacter(rightRow, row)) == null || (neighbourCharacter = graphics.getCharacter(rightRow - 1, row)) == null) continue;
            neighbour = neighbourCharacter.getCharacterString().charAt(0);
            if (borderCharacter.is('\u2502')) {
                if (junctionFromLeftSingle.contains(Character.valueOf(neighbour))) {
                    graphics.setCharacter(rightRow, row, borderCharacter.withCharacter('\u2524'));
                    continue;
                }
                if (!junctionFromLeftDouble.contains(Character.valueOf(neighbour))) continue;
                graphics.setCharacter(rightRow, row, borderCharacter.withCharacter('\u2561'));
                continue;
            }
            if (!borderCharacter.is('\u2551')) continue;
            if (junctionFromLeftSingle.contains(Character.valueOf(neighbour))) {
                graphics.setCharacter(rightRow, row, borderCharacter.withCharacter('\u2562'));
                continue;
            }
            if (!junctionFromLeftDouble.contains(Character.valueOf(neighbour))) continue;
            graphics.setCharacter(rightRow, row, borderCharacter.withCharacter('\u2563'));
        }
    }

    private static class DoubleLineRenderer
    extends AbstractBorderRenderer {
        public DoubleLineRenderer(BorderStyle borderStyle) {
            super(borderStyle);
        }

        @Override
        protected char getTopRightCorner(Theme theme) {
            return theme.getDefinition(DoubleLine.class).getCharacter("TOP_RIGHT_CORNER", '\u2557');
        }

        @Override
        protected char getBottomRightCorner(Theme theme) {
            return theme.getDefinition(DoubleLine.class).getCharacter("BOTTOM_RIGHT_CORNER", '\u255d');
        }

        @Override
        protected char getTopLeftCorner(Theme theme) {
            return theme.getDefinition(DoubleLine.class).getCharacter("TOP_LEFT_CORNER", '\u2554');
        }

        @Override
        protected char getBottomLeftCorner(Theme theme) {
            return theme.getDefinition(DoubleLine.class).getCharacter("BOTTOM_LEFT_CORNER", '\u255a');
        }

        @Override
        protected char getVerticalLine(Theme theme) {
            return theme.getDefinition(DoubleLine.class).getCharacter("VERTICAL_LINE", '\u2551');
        }

        @Override
        protected char getHorizontalLine(Theme theme) {
            return theme.getDefinition(DoubleLine.class).getCharacter("HORIZONTAL_LINE", '\u2550');
        }

        @Override
        protected char getTitleLeft(Theme theme) {
            return theme.getDefinition(DoubleLine.class).getCharacter("TITLE_LEFT", '\u2550');
        }

        @Override
        protected char getTitleRight(Theme theme) {
            return theme.getDefinition(DoubleLine.class).getCharacter("TITLE_RIGHT", '\u2550');
        }
    }

    private static class DoubleLine
    extends StandardBorder {
        private DoubleLine(String title, BorderStyle borderStyle) {
            super(title, borderStyle);
        }

        protected Border.BorderRenderer createDefaultRenderer() {
            return new DoubleLineRenderer(this.borderStyle);
        }
    }

    private static class SingleLineRenderer
    extends AbstractBorderRenderer {
        public SingleLineRenderer(BorderStyle borderStyle) {
            super(borderStyle);
        }

        @Override
        protected char getTopRightCorner(Theme theme) {
            return theme.getDefinition(SingleLine.class).getCharacter("TOP_RIGHT_CORNER", '\u2510');
        }

        @Override
        protected char getBottomRightCorner(Theme theme) {
            return theme.getDefinition(SingleLine.class).getCharacter("BOTTOM_RIGHT_CORNER", '\u2518');
        }

        @Override
        protected char getTopLeftCorner(Theme theme) {
            return theme.getDefinition(SingleLine.class).getCharacter("TOP_LEFT_CORNER", '\u250c');
        }

        @Override
        protected char getBottomLeftCorner(Theme theme) {
            return theme.getDefinition(SingleLine.class).getCharacter("BOTTOM_LEFT_CORNER", '\u2514');
        }

        @Override
        protected char getVerticalLine(Theme theme) {
            return theme.getDefinition(SingleLine.class).getCharacter("VERTICAL_LINE", '\u2502');
        }

        @Override
        protected char getHorizontalLine(Theme theme) {
            return theme.getDefinition(SingleLine.class).getCharacter("HORIZONTAL_LINE", '\u2500');
        }

        @Override
        protected char getTitleLeft(Theme theme) {
            return theme.getDefinition(SingleLine.class).getCharacter("TITLE_LEFT", '\u2500');
        }

        @Override
        protected char getTitleRight(Theme theme) {
            return theme.getDefinition(SingleLine.class).getCharacter("TITLE_RIGHT", '\u2500');
        }
    }

    private static class SingleLine
    extends StandardBorder {
        private SingleLine(String title, BorderStyle borderStyle) {
            super(title, borderStyle);
        }

        protected Border.BorderRenderer createDefaultRenderer() {
            return new SingleLineRenderer(this.borderStyle);
        }
    }

    private static abstract class AbstractBorderRenderer
    implements Border.BorderRenderer {
        private final BorderStyle borderStyle;

        protected AbstractBorderRenderer(BorderStyle borderStyle) {
            this.borderStyle = borderStyle;
        }

        @Override
        public TerminalSize getPreferredSize(Border component) {
            StandardBorder border = (StandardBorder)component;
            Component wrappedComponent = border.getComponent();
            TerminalSize preferredSize = wrappedComponent == null ? TerminalSize.ZERO : wrappedComponent.getPreferredSize();
            preferredSize = preferredSize.withRelativeColumns(2).withRelativeRows(2);
            String borderTitle = border.getTitle();
            return preferredSize.max(new TerminalSize(borderTitle.isEmpty() ? 2 : TerminalTextUtils.getColumnWidth(borderTitle) + 4, 2));
        }

        @Override
        public TerminalPosition getWrappedComponentTopLeftOffset() {
            return TerminalPosition.OFFSET_1x1;
        }

        @Override
        public TerminalSize getWrappedComponentSize(TerminalSize borderSize) {
            return borderSize.withRelativeColumns(-Math.min(2, borderSize.getColumns())).withRelativeRows(-Math.min(2, borderSize.getRows()));
        }

        @Override
        public void drawComponent(TextGUIGraphics graphics, Border component) {
            StandardBorder border = (StandardBorder)component;
            Component wrappedComponent = border.getComponent();
            if (wrappedComponent == null) {
                return;
            }
            TerminalSize drawableArea = graphics.getSize();
            char horizontalLine = this.getHorizontalLine(component.getTheme());
            char verticalLine = this.getVerticalLine(component.getTheme());
            char bottomLeftCorner = this.getBottomLeftCorner(component.getTheme());
            char topLeftCorner = this.getTopLeftCorner(component.getTheme());
            char bottomRightCorner = this.getBottomRightCorner(component.getTheme());
            char topRightCorner = this.getTopRightCorner(component.getTheme());
            char titleLeft = this.getTitleLeft(component.getTheme());
            char titleRight = this.getTitleRight(component.getTheme());
            ThemeDefinition themeDefinition = component.getTheme().getDefinition(AbstractBorder.class);
            if (this.borderStyle == BorderStyle.Bevel) {
                graphics.applyThemeStyle(themeDefinition.getPreLight());
            } else {
                graphics.applyThemeStyle(themeDefinition.getNormal());
            }
            graphics.setCharacter(0, drawableArea.getRows() - 1, bottomLeftCorner);
            if (drawableArea.getRows() > 2) {
                graphics.drawLine(new TerminalPosition(0, drawableArea.getRows() - 2), new TerminalPosition(0, 1), verticalLine);
            }
            graphics.setCharacter(0, 0, topLeftCorner);
            if (drawableArea.getColumns() > 2) {
                graphics.drawLine(new TerminalPosition(1, 0), new TerminalPosition(drawableArea.getColumns() - 2, 0), horizontalLine);
            }
            if (this.borderStyle == BorderStyle.ReverseBevel) {
                graphics.applyThemeStyle(themeDefinition.getPreLight());
            } else {
                graphics.applyThemeStyle(themeDefinition.getNormal());
            }
            graphics.setCharacter(drawableArea.getColumns() - 1, 0, topRightCorner);
            if (drawableArea.getRows() > 2) {
                graphics.drawLine(new TerminalPosition(drawableArea.getColumns() - 1, 1), new TerminalPosition(drawableArea.getColumns() - 1, drawableArea.getRows() - 2), verticalLine);
            }
            graphics.setCharacter(drawableArea.getColumns() - 1, drawableArea.getRows() - 1, bottomRightCorner);
            if (drawableArea.getColumns() > 2) {
                graphics.drawLine(new TerminalPosition(1, drawableArea.getRows() - 1), new TerminalPosition(drawableArea.getColumns() - 2, drawableArea.getRows() - 1), horizontalLine);
            }
            if (border.getTitle() != null && !border.getTitle().isEmpty() && drawableArea.getColumns() >= TerminalTextUtils.getColumnWidth(border.getTitle()) + 4) {
                graphics.applyThemeStyle(themeDefinition.getActive());
                graphics.putString(2, 0, border.getTitle());
                if (this.borderStyle == BorderStyle.Bevel) {
                    graphics.applyThemeStyle(themeDefinition.getPreLight());
                } else {
                    graphics.applyThemeStyle(themeDefinition.getNormal());
                }
                graphics.setCharacter(1, 0, titleLeft);
                graphics.setCharacter(2 + TerminalTextUtils.getColumnWidth(border.getTitle()), 0, titleRight);
            }
            wrappedComponent.draw(graphics.newTextGraphics(this.getWrappedComponentTopLeftOffset(), this.getWrappedComponentSize(drawableArea)));
            Borders.joinLinesWithFrame(graphics);
        }

        protected abstract char getHorizontalLine(Theme var1);

        protected abstract char getVerticalLine(Theme var1);

        protected abstract char getBottomLeftCorner(Theme var1);

        protected abstract char getTopLeftCorner(Theme var1);

        protected abstract char getBottomRightCorner(Theme var1);

        protected abstract char getTopRightCorner(Theme var1);

        protected abstract char getTitleLeft(Theme var1);

        protected abstract char getTitleRight(Theme var1);
    }

    private static abstract class StandardBorder
    extends AbstractBorder {
        private final String title;
        protected final BorderStyle borderStyle;

        protected StandardBorder(String title, BorderStyle borderStyle) {
            if (title == null) {
                throw new IllegalArgumentException("Cannot create a border with null title");
            }
            this.borderStyle = borderStyle;
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + this.title + "}";
        }
    }

    private static enum BorderStyle {
        Solid,
        Bevel,
        ReverseBevel;

    }
}

