/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.graphics;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.ThemeStyle;
import java.util.Arrays;
import java.util.EnumSet;

public class DefaultMutableThemeStyle
implements ThemeStyle {
    private TextColor foreground;
    private TextColor background;
    private EnumSet<SGR> sgrs;

    public DefaultMutableThemeStyle(ThemeStyle themeStyleToCopy) {
        this(themeStyleToCopy.getForeground(), themeStyleToCopy.getBackground(), themeStyleToCopy.getSGRs());
    }

    public DefaultMutableThemeStyle(TextColor foreground, TextColor background, SGR ... sgrs) {
        this(foreground, background, sgrs.length > 0 ? EnumSet.copyOf(Arrays.asList(sgrs)) : EnumSet.noneOf(SGR.class));
    }

    private DefaultMutableThemeStyle(TextColor foreground, TextColor background, EnumSet<SGR> sgrs) {
        if (foreground == null) {
            throw new IllegalArgumentException("Cannot set SimpleTheme's style foreground to null");
        }
        if (background == null) {
            throw new IllegalArgumentException("Cannot set SimpleTheme's style background to null");
        }
        this.foreground = foreground;
        this.background = background;
        this.sgrs = EnumSet.copyOf(sgrs);
    }

    @Override
    public TextColor getForeground() {
        return this.foreground;
    }

    @Override
    public TextColor getBackground() {
        return this.background;
    }

    @Override
    public EnumSet<SGR> getSGRs() {
        return EnumSet.copyOf(this.sgrs);
    }

    public DefaultMutableThemeStyle setForeground(TextColor foreground) {
        this.foreground = foreground;
        return this;
    }

    public DefaultMutableThemeStyle setBackground(TextColor background) {
        this.background = background;
        return this;
    }

    public DefaultMutableThemeStyle setSGRs(EnumSet<SGR> sgrs) {
        this.sgrs = EnumSet.copyOf(sgrs);
        return this;
    }
}

